/*
 * Decompiled with CFR 0.152.
 */
package mage.designations;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.constants.Zone;
import mage.designations.SpeedEffect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SpeedTriggeredAbility
extends TriggeredAbilityImpl {
    SpeedTriggeredAbility() {
        super(Zone.ALL, new SpeedEffect());
        this.setTriggersLimitEachTurn(1);
    }

    private SpeedTriggeredAbility(SpeedTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public SpeedTriggeredAbility copy() {
        return new SpeedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_LIFE_BATCH_FOR_ONE_PLAYER;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return game.isActivePlayer(this.getControllerId()) && game.getOpponents(this.getControllerId()).contains(event.getTargetId());
    }

    @Override
    public boolean checkInterveningIfClause(Game game) {
        return Optional.ofNullable(this.getControllerId()).map(game::getPlayer).map(Player::getSpeed).map(x -> x < 4).orElse(false);
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return true;
    }

    @Override
    public String getRule() {
        return "Whenever one or more opponents lose life during your turn, if your speed is less than 4, increase your speed by 1. This ability triggers only once each turn.";
    }
}

