/*
 * Decompiled with CFR 0.152.
 */
package mage.filter;

import java.util.ArrayList;
import java.util.List;
import mage.filter.Filter;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;

public abstract class FilterImpl<E>
implements Filter<E> {
    protected List<Predicate<? super E>> predicates = new ArrayList<Predicate<? super E>>();
    protected String message;
    protected boolean lockedFilter;

    @Override
    public abstract FilterImpl<E> copy();

    public FilterImpl(String name) {
        this.message = name;
        this.lockedFilter = false;
    }

    protected FilterImpl(FilterImpl<E> filter) {
        this.message = filter.message;
        this.predicates = new ArrayList<Predicate<Predicate<? super E>>>(filter.predicates);
        this.lockedFilter = false;
    }

    @Override
    public boolean match(E e, Game game) {
        if (this.checkObjectClass(e)) {
            return Predicates.and(this.predicates).apply(e, game);
        }
        return false;
    }

    @Override
    public final Filter<E> add(Predicate<? super E> predicate) {
        if (this.isLockedFilter()) {
            throw new UnsupportedOperationException("You may not modify a locked filter");
        }
        this.predicates.add(predicate);
        return this;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public final void setMessage(String message) {
        if (this.isLockedFilter()) {
            throw new UnsupportedOperationException("You may not modify a locked filter");
        }
        this.message = message;
    }

    public String toString() {
        return this.message;
    }

    @Override
    public boolean isLockedFilter() {
        return this.lockedFilter;
    }

    @Override
    public void setLockedFilter(boolean lockedFilter) {
        this.lockedFilter = lockedFilter;
    }

    @Override
    public List<Predicate<? super E>> getPredicates() {
        return this.predicates;
    }
}

