/*
 * Decompiled with CFR 0.152.
 */
package mage.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mage.ObjectColor;

public class FilterMana
implements Serializable {
    protected boolean black;
    protected boolean green;
    protected boolean white;
    protected boolean red;
    protected boolean blue;
    protected boolean generic;
    protected boolean colorless;

    public FilterMana() {
    }

    public FilterMana(FilterMana filter) {
        this.black = filter.black;
        this.green = filter.green;
        this.white = filter.white;
        this.red = filter.red;
        this.blue = filter.blue;
        this.generic = filter.generic;
        this.colorless = filter.colorless;
    }

    public boolean isBlack() {
        return this.black;
    }

    public void setBlack(boolean black) {
        this.black = black;
    }

    public boolean isGreen() {
        return this.green;
    }

    public void setGreen(boolean green) {
        this.green = green;
    }

    public boolean isWhite() {
        return this.white;
    }

    public void setWhite(boolean white) {
        this.white = white;
    }

    public boolean isRed() {
        return this.red;
    }

    public void setRed(boolean red) {
        this.red = red;
    }

    public boolean isBlue() {
        return this.blue;
    }

    public void setBlue(boolean blue) {
        this.blue = blue;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public void setGeneric(boolean generic) {
        this.generic = generic;
    }

    public boolean isColorless() {
        return !this.white && !this.blue && !this.black && !this.red && !this.green || this.colorless;
    }

    public void setColorless(boolean colorless) {
        this.colorless = colorless;
    }

    public boolean isMulticolored() {
        return this.getColorCount() > 1;
    }

    public int getColorCount() {
        int colorCount = 0;
        if (this.white) {
            ++colorCount;
        }
        if (this.blue) {
            ++colorCount;
        }
        if (this.black) {
            ++colorCount;
        }
        if (this.red) {
            ++colorCount;
        }
        if (this.green) {
            ++colorCount;
        }
        return colorCount;
    }

    public void addAll(FilterMana filterMana) {
        if (filterMana.white) {
            this.white = true;
        }
        if (filterMana.blue) {
            this.blue = true;
        }
        if (filterMana.black) {
            this.black = true;
        }
        if (filterMana.red) {
            this.red = true;
        }
        if (filterMana.green) {
            this.green = true;
        }
    }

    public void removeAll(FilterMana filterMana) {
        if (filterMana.white) {
            this.white = false;
        }
        if (filterMana.blue) {
            this.blue = false;
        }
        if (filterMana.black) {
            this.black = false;
        }
        if (filterMana.red) {
            this.red = false;
        }
        if (filterMana.green) {
            this.green = false;
        }
    }

    public List<ObjectColor> getColors() {
        ArrayList<ObjectColor> colors = new ArrayList<ObjectColor>();
        if (this.white) {
            colors.add(ObjectColor.WHITE);
        }
        if (this.blue) {
            colors.add(ObjectColor.BLUE);
        }
        if (this.black) {
            colors.add(ObjectColor.BLACK);
        }
        if (this.red) {
            colors.add(ObjectColor.RED);
        }
        if (this.green) {
            colors.add(ObjectColor.GREEN);
        }
        return colors;
    }

    public FilterMana copy() {
        return new FilterMana(this);
    }

    public String toString() {
        return (this.white ? "{W}" : "") + (this.blue ? "{U}" : "") + (this.black ? "{B}" : "") + (this.red ? "{R}" : "") + (this.green ? "{G}" : "");
    }
}

