/*
 * Decompiled with CFR 0.152.
 */
package mage.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterImpl;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

public class FilterPlayer
extends FilterImpl<Player> {
    protected final List<ObjectSourcePlayerPredicate<Player>> extraPredicates = new ArrayList<ObjectSourcePlayerPredicate<Player>>();

    public FilterPlayer() {
        this("player");
    }

    public FilterPlayer(String name) {
        super(name);
    }

    protected FilterPlayer(FilterPlayer filter) {
        super(filter);
        this.extraPredicates.addAll(filter.extraPredicates);
    }

    public FilterPlayer add(ObjectSourcePlayerPredicate predicate) {
        if (this.isLockedFilter()) {
            throw new UnsupportedOperationException("You may not modify a locked filter");
        }
        Predicates.makeSurePredicateCompatibleWithFilter(predicate, Player.class);
        this.extraPredicates.add(predicate);
        return this;
    }

    @Override
    public boolean checkObjectClass(Object object) {
        return object instanceof Player;
    }

    public boolean match(Player checkPlayer, UUID sourceControllerId, Ability source, Game game) {
        if (!this.match(checkPlayer, game)) {
            return false;
        }
        ObjectSourcePlayer<Player> osp = new ObjectSourcePlayer<Player>(checkPlayer, sourceControllerId, source);
        return this.extraPredicates.stream().allMatch(p -> p.apply(osp, game));
    }

    @Override
    public FilterPlayer copy() {
        return new FilterPlayer(this);
    }

    @Override
    public List<Predicate> getExtraPredicates() {
        return new ArrayList<Predicate>(this.extraPredicates);
    }
}

