/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.filter.predicate.Predicate;
import mage.game.Game;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new AndPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        return new AndPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        return new AndPredicate(Predicates.asList(Predicates.checkNotNull(first), Predicates.checkNotNull(second)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return new OrPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        return new OrPredicate(Predicates.asList(first, second));
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> first, Predicate<? super T> second) {
        return Arrays.asList(first, second);
    }

    private static <T> List<T> defensiveCopy(T ... array) {
        return Predicates.defensiveCopy(Arrays.asList(array));
    }

    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : iterable) {
            list.add(Predicates.checkNotNull(element));
        }
        return list;
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    private static String commaJoin(List components) {
        StringBuilder sb = new StringBuilder();
        for (Object component : components) {
            sb.append(component.toString());
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static void collectAllComponents(Predicate predicate, List<Predicate> res) {
        if (predicate instanceof NotPredicate) {
            Predicates.collectAllComponents(((NotPredicate)predicate).predicate, res);
        } else if (predicate instanceof AndPredicate) {
            Predicates.collectAllComponents(((AndPredicate)predicate).components, null, res);
        } else if (predicate instanceof OrPredicate) {
            Predicates.collectAllComponents(((OrPredicate)predicate).components, null, res);
        } else {
            res.add(predicate);
        }
    }

    public static void collectAllComponents(List<Predicate> predicates, List<Predicate> extraPredicates, List<Predicate> res) {
        predicates.forEach(p -> Predicates.collectAllComponents(p, res));
        if (extraPredicates != null) {
            extraPredicates.forEach(p -> Predicates.collectAllComponents(p, res));
        }
    }

    public static void makeSurePredicateCompatibleWithFilter(Predicate predicate, Class ... compatibleClasses) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        Predicates.collectAllComponents(predicate, list);
        list.forEach(p -> {
            Class predicateGenericParamClass = Predicates.findGenericParam(predicate);
            if (predicateGenericParamClass == null) {
                throw new IllegalArgumentException("Somthing wrong. Can't find predicate's generic param for " + predicate.getClass());
            }
            if (!Arrays.stream(compatibleClasses).anyMatch(f -> predicateGenericParamClass.isAssignableFrom((Class<?>)f))) {
                throw new IllegalArgumentException(String.format("Wrong code usage: predicate [%s] with generic param [%s] can't be added to filter, allow only %s", predicate.getClass(), predicateGenericParamClass, Arrays.toString(compatibleClasses)));
            }
        });
    }

    private static Class findGenericParam(Predicate predicate) {
        Type[] interfaces;
        for (Type type : interfaces = predicate.getClass().getGenericInterfaces()) {
            Type actualType;
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            if (!(type instanceof ParameterizedType) || (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length <= 0 || !((actualType = actualTypeArguments[0]) instanceof Class)) continue;
            return (Class)actualType;
        }
        return null;
    }

    private static class OrPredicate<T>
    implements Predicate<T> {
        private final List<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private OrPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t, Game game) {
            return this.components.stream().anyMatch(predicate -> predicate.apply(t, game));
        }

        public String toString() {
            return "Or(" + Predicates.commaJoin(this.components) + ')';
        }
    }

    private static class AndPredicate<T>
    implements Predicate<T> {
        private final List<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private AndPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t, Game game) {
            return this.components.stream().allMatch(predicate -> predicate.apply(t, game));
        }

        public String toString() {
            return "And(" + Predicates.commaJoin(this.components) + ')';
        }
    }

    private static class NotPredicate<T>
    implements Predicate<T> {
        final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        NotPredicate(Predicate<T> predicate) {
            this.predicate = (Predicate)Predicates.checkNotNull(predicate);
        }

        @Override
        public boolean apply(T t, Game game) {
            return !this.predicate.apply(t, game);
        }

        public String toString() {
            return "Not(" + this.predicate.toString() + ')';
        }
    }
}

