/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.mageobject;

import java.util.Objects;
import mage.MageObject;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.keyword.special.JohanVigilanceAbility;
import mage.cards.Card;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.util.CardUtil;

public enum NoAbilityPredicate implements Predicate<MageObject>
{
    instance;


    @Override
    public boolean apply(MageObject input, Game game) {
        Abilities<Ability> abilities;
        boolean isFaceDown = false;
        if (input instanceof Card) {
            abilities = ((Card)input).getAbilities(game);
            isFaceDown = ((Card)input).isFaceDown(game);
        } else {
            abilities = input.getAbilities();
        }
        if (isFaceDown) {
            for (Ability ability : abilities) {
                if (ability.getWorksFaceDown() || CardUtil.isInformationAbility(ability) || Objects.equals(ability.getClass(), SpellAbility.class) || ability.getClass().equals(JohanVigilanceAbility.class)) continue;
                return false;
            }
            return true;
        }
        for (Ability ability : abilities) {
            if (Objects.equals(ability.getClass(), SpellAbility.class) || ability.getClass().equals(JohanVigilanceAbility.class)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "with no abilities";
    }
}

