/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.other;

import java.util.UUID;
import mage.constants.TargetController;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.watchers.common.PlayerDamagedBySourceWatcher;

public class DamagedPlayerThisTurnPredicate
implements ObjectSourcePlayerPredicate<Controllable> {
    private final TargetController playerDamaged;
    private final boolean combatDamageOnly;

    public DamagedPlayerThisTurnPredicate(TargetController playerDamaged) {
        this(playerDamaged, false);
    }

    public DamagedPlayerThisTurnPredicate(TargetController playerDamaged, boolean combatDamageOnly) {
        this.playerDamaged = playerDamaged;
        this.combatDamageOnly = combatDamageOnly;
    }

    @Override
    public boolean apply(ObjectSourcePlayer<Controllable> input, Game game) {
        UUID objectId = input.getObject().getId();
        UUID playerId = input.getPlayerId();
        switch (this.playerDamaged) {
            case YOU: {
                return this.playerDealtDamageBy(playerId, objectId, game);
            }
            case SOURCE_CONTROLLER: {
                UUID controllerId = input.getSource().getControllerId();
                return this.playerDealtDamageBy(controllerId, objectId, game);
            }
            case OPPONENT: {
                for (UUID opponentId : game.getOpponents(playerId)) {
                    if (!this.playerDealtDamageBy(opponentId, objectId, game)) continue;
                    return true;
                }
                return false;
            }
            case NOT_YOU: {
                for (UUID notYouId : game.getState().getPlayersInRange(playerId, game)) {
                    if (notYouId.equals(playerId) || !this.playerDealtDamageBy(notYouId, objectId, game)) continue;
                    return true;
                }
                return false;
            }
            case ANY: {
                for (UUID anyId : game.getState().getPlayersInRange(playerId, game)) {
                    if (!this.playerDealtDamageBy(anyId, objectId, game)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new UnsupportedOperationException("TargetController not supported");
    }

    private boolean playerDealtDamageBy(UUID playerId, UUID objectId, Game game) {
        PlayerDamagedBySourceWatcher watcher = game.getState().getWatcher(PlayerDamagedBySourceWatcher.class, playerId);
        if (watcher == null) {
            return false;
        }
        if (this.combatDamageOnly) {
            return watcher.hasSourceDoneCombatDamage(objectId, game);
        }
        return watcher.hasSourceDoneDamage(objectId, game);
    }

    public String toString() {
        return "Damaged player (" + this.playerDamaged.toString() + ')';
    }
}

