/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.permanent;

import java.util.UUID;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.watchers.common.BlockedAttackerWatcher;

public class BlockedByIdPredicate
implements Predicate<Permanent> {
    private final UUID blockerId;

    public BlockedByIdPredicate(UUID blockerId) {
        this.blockerId = blockerId;
    }

    @Override
    public boolean apply(Permanent input, Game game) {
        BlockedAttackerWatcher watcher;
        for (CombatGroup combatGroup : game.getCombat().getGroups()) {
            if (!combatGroup.getBlockers().contains(this.blockerId) || !combatGroup.getAttackers().contains(input.getId())) continue;
            return true;
        }
        Permanent blocker = game.getPermanentOrLKIBattlefield(this.blockerId);
        if (blocker != null && (watcher = game.getState().getWatcher(BlockedAttackerWatcher.class)) != null) {
            return watcher.creatureHasBlockedAttacker(input, blocker, game);
        }
        return false;
    }

    public String toString() {
        return "Blocked by " + this.blockerId.toString();
    }
}

