/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.TriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.Dungeon;
import mage.game.command.RoomTriggeredAbility;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;

public class DungeonRoom {
    private final UUID id;
    private final String name;
    private final List<DungeonRoom> nextRooms = new ArrayList<DungeonRoom>();
    private final RoomTriggeredAbility roomTriggeredAbility;

    public DungeonRoom(String name, Effect ... effects) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.roomTriggeredAbility = new RoomTriggeredAbility(this, effects);
    }

    private DungeonRoom(DungeonRoom room) {
        this.id = room.id;
        this.name = room.name;
        this.roomTriggeredAbility = new RoomTriggeredAbility(this, room.roomTriggeredAbility);
    }

    public DungeonRoom copy() {
        return new DungeonRoom(this);
    }

    public void addTarget(Target target) {
        this.roomTriggeredAbility.addTarget(target);
    }

    public void addNextRoom(DungeonRoom room) {
        this.nextRooms.add(room);
    }

    public RoomTriggeredAbility getRoomTriggeredAbility() {
        return this.roomTriggeredAbility;
    }

    public UUID getId() {
        return this.id;
    }

    public String toString() {
        return this.roomTriggeredAbility.getText();
    }

    public String getName() {
        return this.name;
    }

    public boolean hasNextRoom() {
        return !this.nextRooms.isEmpty();
    }

    List<DungeonRoom> getNextRooms() {
        return this.nextRooms;
    }

    public DungeonRoom chooseNextRoom(UUID playerId, Game game) {
        Dungeon dungeon = game.getPlayerDungeon(playerId);
        if (dungeon == null) {
            return null;
        }
        switch (this.nextRooms.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.nextRooms.get(0);
            }
            case 2: {
                DungeonRoom room1 = this.nextRooms.get(0);
                DungeonRoom room2 = this.nextRooms.get(1);
                Player player = game.getPlayer(playerId);
                if (player == null) {
                    return null;
                }
                return player.chooseUse(Outcome.Neutral, "Choose which room to go to in", "dungeon: " + dungeon.getLogName(), room1.name, room2.name, null, game) ? room1 : room2;
            }
        }
        throw new UnsupportedOperationException("there shouldn't be more than two rooms to go to");
    }

    String generateDestinationText() {
        if (this.nextRooms.isEmpty()) {
            return "";
        }
        return " <i>(Leads to " + this.nextRooms.stream().map(DungeonRoom::getName).reduce((a, b) -> a + " or " + b).orElse("") + ")</i>";
    }

    public static boolean isRoomTrigger(StackObject stackObject) {
        return stackObject instanceof StackAbility && stackObject.getStackAbility() instanceof RoomTriggeredAbility;
    }

    public static boolean isRoomTrigger(TriggeredAbility ability) {
        return ability instanceof RoomTriggeredAbility;
    }
}

