/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class MadWizardsLairEffect
extends OneShotEffect {
    MadWizardsLairEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw three cards and reveal them. You may cast one of them without paying its mana cost";
    }

    private MadWizardsLairEffect(MadWizardsLairEffect effect) {
        super(effect);
    }

    @Override
    public MadWizardsLairEffect copy() {
        return new MadWizardsLairEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        if (player.drawCards(3, source, game) != cards.size()) {
            return true;
        }
        player.revealCards(source, (Cards)cards, game);
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        player.choose(Outcome.PlayForFree, cards, target, source, game);
        Card card = player.getHand().get(target.getFirstTarget(), game);
        if (card == null) {
            return true;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), Boolean.TRUE);
        player.cast(player.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        return true;
    }
}

