/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.dungeons.OublietteTarget;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OublietteEffect
extends OneShotEffect {
    OublietteEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "discard a card and sacrifice an artifact, a creature, and a land";
    }

    private OublietteEffect(OublietteEffect effect) {
        super(effect);
    }

    @Override
    public OublietteEffect copy() {
        return new OublietteEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.discard(1, false, false, source, game);
        int saccable = OublietteTarget.checkTargetCount(source, game);
        if (saccable < 1) {
            return true;
        }
        OublietteTarget target = new OublietteTarget(Math.min(saccable, 3));
        player.choose(Outcome.Sacrifice, target, source, game);
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

