/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.dungeons.TombOfAnnihilationDungeon;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class SandfallCellEffect
extends OneShotEffect {
    SandfallCellEffect() {
        super(Outcome.Neutral);
        this.staticText = "each player loses 2 life unless they sacrifice an artifact, a creature, or a land";
    }

    private SandfallCellEffect(SandfallCellEffect effect) {
        super(effect);
    }

    @Override
    public SandfallCellEffect copy() {
        return new SandfallCellEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player;
        HashMap<UUID, Permanent> map = new HashMap<UUID, Permanent>();
        for (UUID uUID : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(uUID);
            if (player == null) continue;
            TargetPermanent target = new TargetPermanent(0, 1, TombOfAnnihilationDungeon.filter, true);
            player.choose(Outcome.PreventDamage, target, source, game);
            map.put(uUID, game.getPermanent(target.getFirstTarget()));
        }
        for (Map.Entry entry : map.entrySet()) {
            player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            if (entry.getValue() != null) {
                ((Permanent)entry.getValue()).sacrifice(source, game);
                continue;
            }
            player.loseLife(2, game, source, false);
        }
        return true;
    }
}

