/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HexproofAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class ThroneOfTheDeadThreeEffect
extends OneShotEffect {
    ThroneOfTheDeadThreeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top ten cards of your library. Put a creature card from among them onto the battlefield with three +1/+1 counters on it. It gains hexproof until your next turn. Then shuffle.";
    }

    private ThroneOfTheDeadThreeEffect(ThroneOfTheDeadThreeEffect effect) {
        super(effect);
    }

    @Override
    public ThroneOfTheDeadThreeEffect copy() {
        return new ThroneOfTheDeadThreeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 10));
        player.revealCards(source, (Cards)cards, game);
        switch (cards.count(StaticFilters.FILTER_CARD_CREATURE, game)) {
            case 0: {
                card = null;
                break;
            }
            case 1: {
                card = RandomUtil.randomFromCollection(cards.getCards(StaticFilters.FILTER_CARD_CREATURE, game));
                break;
            }
            default: {
                TargetCardInLibrary target = new TargetCardInLibrary(StaticFilters.FILTER_CARD_CREATURE);
                player.choose(this.outcome, cards, target, source, game);
                card = cards.get(target.getFirstTarget(), game);
            }
        }
        if (card != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield(card, game);
            if (permanent != null) {
                permanent.addCounters(CounterType.P1P1.createInstance(3), source, game);
                game.addEffect(new GainAbilityTargetEffect(HexproofAbility.getInstance(), Duration.UntilYourNextTurn).setTargetPointer(new FixedTarget(permanent, game)), source);
            }
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

