/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.watchers.common.ManaPaidSourceWatcher;

class ChandraDressedToKillEmblemEffect
extends OneShotEffect {
    public ChandraDressedToKillEmblemEffect() {
        super(Outcome.Damage);
        this.staticText = "this emblem deals X damage to any target, where X is the amount of mana spent to cast that spell";
    }

    private ChandraDressedToKillEmblemEffect(ChandraDressedToKillEmblemEffect effect) {
        super(effect);
    }

    @Override
    public ChandraDressedToKillEmblemEffect copy() {
        return new ChandraDressedToKillEmblemEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (controller == null || spell == null) {
            return false;
        }
        int manaPaid = ManaPaidSourceWatcher.getTotalPaid(spell.getId(), game);
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            permanent.damage(manaPaid, source, game);
            return true;
        }
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            player.damage(manaPaid, source, game);
            return true;
        }
        return false;
    }
}

