/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;
import mage.watchers.common.CastFromGraveyardWatcher;

class JayaBallardReplacementEffect
extends ReplacementEffectImpl {
    public JayaBallardReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Exile);
        this.staticText = "If a spell cast this way would be put into a graveyard this turn, exile it instead";
    }

    protected JayaBallardReplacementEffect(JayaBallardReplacementEffect effect) {
        super(effect);
    }

    @Override
    public JayaBallardReplacementEffect copy() {
        return new JayaBallardReplacementEffect(this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = (Card)game.getState().getValue("JayaBallard")) != null) {
            ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        }
        return false;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card;
        if (Zone.GRAVEYARD == ((ZoneChangeEvent)event).getToZone() && (card = game.getCard(event.getSourceId())) != null && (card.isInstant(game) || card.isSorcery(game))) {
            CastFromGraveyardWatcher watcher = game.getState().getWatcher(CastFromGraveyardWatcher.class);
            return watcher != null && watcher.spellWasCastFromGraveyard(event.getTargetId(), game.getState().getZoneChangeCounter(event.getTargetId()));
        }
        return false;
    }
}

