/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;

class LilianaDefiantNecromancerEmblemEffect
extends OneShotEffect {
    LilianaDefiantNecromancerEmblemEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return it to the battlefield under your control at the beginning of the next end step";
    }

    LilianaDefiantNecromancerEmblemEffect(LilianaDefiantNecromancerEmblemEffect effect) {
        super(effect);
    }

    @Override
    public LilianaDefiantNecromancerEmblemEffect copy() {
        return new LilianaDefiantNecromancerEmblemEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            ReturnFromGraveyardToBattlefieldTargetEffect effect = new ReturnFromGraveyardToBattlefieldTargetEffect();
            effect.setTargetPointer(new FixedTarget(card, game));
            effect.setText("return that card to the battlefield at the beginning of the next end step");
            game.addDelayedTriggeredAbility(new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect, TargetController.ANY), source);
            return true;
        }
        return false;
    }
}

