/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LukkaWaywardBonderEmblemEffect
extends OneShotEffect {
    LukkaWaywardBonderEmblemEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals damage equal to its power to any target";
    }

    private LukkaWaywardBonderEmblemEffect(LukkaWaywardBonderEmblemEffect effect) {
        super(effect);
    }

    @Override
    public LukkaWaywardBonderEmblemEffect copy() {
        return new LukkaWaywardBonderEmblemEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (permanent == null || permanent.getPower().getValue() < 1) {
            return false;
        }
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (targetPermanent != null) {
            return targetPermanent.damage(permanent.getPower().getValue(), permanent.getId(), source, game) > 0;
        }
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer != null) {
            return targetPlayer.damage(permanent.getPower().getValue(), permanent.getId(), source, game) > 0;
        }
        return false;
    }
}

