/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class RadiationEffect
extends OneShotEffect {
    RadiationEffect() {
        super(Outcome.Neutral);
        this.staticText = "mill that many cards. For each nonland card milled this way, you lose 1 life and remove one rad counter.";
    }

    private RadiationEffect(RadiationEffect effect) {
        super(effect);
    }

    @Override
    public RadiationEffect copy() {
        return new RadiationEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = player.getCountersCount(CounterType.RAD);
        Cards milled = player.millCards(amount, source, game);
        int countNonLand = milled.count(StaticFilters.FILTER_CARD_NON_LAND, player.getId(), source, game);
        if (countNonLand > 0) {
            GameEvent event = new GameEvent(GameEvent.EventType.RADIATION_GAIN_LIFE, null, source, player.getId(), amount, false);
            if (game.replaceEvent(event)) {
                player.gainLife(countNonLand, game, source);
            } else {
                player.loseLife(countNonLand, game, source, false);
            }
            player.loseCounters(CounterType.RAD.getName(), countNonLand, source, game);
        }
        return true;
    }
}

