/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.AbilityImpl;
import mage.abilities.common.AttacksCreatureYouControlTriggeredAbility;
import mage.abilities.common.DealsDamageToAPlayerAllTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.DrawDiscardControllerEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.cards.repository.TokenInfo;
import mage.cards.repository.TokenRepository;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.command.Emblem;
import mage.game.command.emblems.TheRingEmblemEvasionEffect;
import mage.game.command.emblems.TheRingEmblemLegendaryEffect;
import mage.game.command.emblems.TheRingEmblemPredicate;
import mage.game.command.emblems.TheRingEmblemTriggeredAbility;
import mage.players.Player;
import mage.watchers.common.TemptedByTheRingWatcher;

public final class TheRingEmblem
extends Emblem {
    private static final FilterPermanent filter = new FilterControlledPermanent("your Ring-bearer");

    public TheRingEmblem() {
        this((UUID)null);
    }

    public TheRingEmblem(UUID controllerId) {
        super("The Ring");
        this.setControllerId(controllerId);
        this.setSourceObjectAndInitImage(null);
    }

    @Override
    public void setSourceObjectAndInitImage(MageObject sourceObject) {
        this.sourceObject = sourceObject;
        TokenInfo foundInfo = TokenRepository.instance.findPreferredTokenInfoForXmage("The Ring", null);
        if (foundInfo == null) {
            throw new IllegalArgumentException("Wrong code usage: can't find xmage token info for: The Ring");
        }
        this.setExpansionSetCode(foundInfo.getSetCode());
        this.setUsesVariousArt(false);
        this.setCardNumber("");
        this.setImageFileName("");
        this.setImageNumber(foundInfo.getImageNumber());
    }

    private TheRingEmblem(TheRingEmblem card) {
        super(card);
    }

    @Override
    public TheRingEmblem copy() {
        return new TheRingEmblem(this);
    }

    public void addNextAbility(Game game) {
        Player player;
        AbilityImpl ability;
        String logText;
        switch (TemptedByTheRingWatcher.getCount(this.getControllerId(), game)) {
            case 0: {
                logText = "Your Ring-bearer is legendary and can't be blocked by creatures with greater power.";
                ability = new SimpleStaticAbility(Zone.COMMAND, new TheRingEmblemLegendaryEffect());
                ability.addEffect(new TheRingEmblemEvasionEffect());
                break;
            }
            case 1: {
                logText = "Whenever your Ring-bearer attacks, draw a card, then discard a card.";
                ability = new AttacksCreatureYouControlTriggeredAbility(Zone.COMMAND, new DrawDiscardControllerEffect(1, 1), false, filter, false).setTriggerPhrase("Whenever your Ring-bearer attacks, ");
                break;
            }
            case 2: {
                logText = "Whenever your Ring-bearer becomes blocked by a creature, that creature's controller sacrifices it at end of combat.";
                ability = new TheRingEmblemTriggeredAbility();
                break;
            }
            case 3: {
                logText = "Whenever your Ring-bearer deals combat damage to a player, each opponent loses 3 life.";
                ability = new DealsDamageToAPlayerAllTriggeredAbility(Zone.COMMAND, new LoseLifeOpponentsEffect(3), filter, false, SetTargetPointer.NONE, true, false);
                break;
            }
            default: {
                return;
            }
        }
        UUID controllerId = this.getControllerId();
        this.getAbilities().add(ability);
        ability.setSourceId(this.getId());
        ability.setControllerId(controllerId);
        game.getState().addAbility((Ability)ability, this);
        String name = "";
        if (controllerId != null && (player = game.getPlayer(controllerId)) != null) {
            name = player.getLogName();
        }
        game.informPlayers(name + " gains a new Ring ability: \"" + logText + "\"");
    }

    static {
        filter.add(TheRingEmblemPredicate.instance);
    }
}

