/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.ArrayList;
import mage.ObjectColor;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MainPhaseStackEmptyCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RollPlanarDieEffect;
import mage.abilities.effects.common.cost.PlanarDieRollCostIncreasingEffect;
import mage.constants.Planes;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.command.Plane;
import mage.game.command.planes.AgyremEffect;
import mage.game.command.planes.AgyremEffect2;
import mage.game.command.planes.AgyremRestrictionEffect;
import mage.target.Target;
import mage.watchers.common.PlanarRollWatcher;

public class AgyremPlane
extends Plane {
    private static final FilterCreaturePermanent filterWhite = new FilterCreaturePermanent("a white creature");
    private static final FilterCreaturePermanent filterNonWhite = new FilterCreaturePermanent("a nonwhite creature");

    public AgyremPlane() {
        this.setPlaneType(Planes.PLANE_AGYREM);
        DiesCreatureTriggeredAbility ability = new DiesCreatureTriggeredAbility(Zone.COMMAND, (Effect)new AgyremEffect(), false, (FilterPermanent)filterWhite, true);
        this.getAbilities().add(ability);
        DiesCreatureTriggeredAbility ability2 = new DiesCreatureTriggeredAbility(Zone.COMMAND, (Effect)new AgyremEffect2(), false, (FilterPermanent)filterNonWhite, true);
        this.getAbilities().add(ability2);
        AgyremRestrictionEffect chaosEffect = new AgyremRestrictionEffect();
        Object chaosTarget = null;
        ArrayList<Effect> chaosEffects = new ArrayList<Effect>();
        chaosEffects.add(chaosEffect);
        ArrayList<Target> chaosTargets = new ArrayList<Target>();
        chaosTargets.add((Target)chaosTarget);
        ActivateIfConditionActivatedAbility chaosAbility = new ActivateIfConditionActivatedAbility(Zone.COMMAND, new RollPlanarDieEffect(chaosEffects, chaosTargets), new GenericManaCost(0), MainPhaseStackEmptyCondition.instance);
        chaosAbility.addWatcher(new PlanarRollWatcher());
        this.getAbilities().add(chaosAbility);
        chaosAbility.setMayActivate(TargetController.ANY);
        this.getAbilities().add(new SimpleStaticAbility(Zone.ALL, new PlanarDieRollCostIncreasingEffect(chaosAbility.getOriginalId())));
    }

    private AgyremPlane(AgyremPlane plane) {
        super(plane);
    }

    @Override
    public AgyremPlane copy() {
        return new AgyremPlane(this);
    }

    static {
        filterWhite.add(new ColorPredicate(ObjectColor.WHITE));
        filterNonWhite.add(Predicates.not(new ColorPredicate(ObjectColor.WHITE)));
    }
}

