/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Planes;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;

class AstralArenaAttackRestrictionEffect
extends RestrictionEffect {
    AstralArenaAttackRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "No more than one creature can attack each combat";
    }

    AstralArenaAttackRestrictionEffect(AstralArenaAttackRestrictionEffect effect) {
        super(effect);
    }

    @Override
    public AstralArenaAttackRestrictionEffect copy() {
        return new AstralArenaAttackRestrictionEffect(this);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null) {
            return false;
        }
        return cPlane.getPlaneType().equals((Object)Planes.PLANE_ASTRAL_ARENA);
    }

    @Override
    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        return game.getCombat().getAttackers().isEmpty();
    }
}

