/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.game.Game;
import mage.game.command.Plane;
import mage.players.Player;
import mage.util.CardUtil;

class DrawCardsActivePlayerEffect
extends OneShotEffect {
    protected DynamicValue amount;

    public DrawCardsActivePlayerEffect(int amount) {
        this(StaticValue.get(amount));
    }

    public DrawCardsActivePlayerEffect(DynamicValue amount) {
        super(Outcome.DrawCard);
        this.amount = amount.copy();
        this.setText();
    }

    protected DrawCardsActivePlayerEffect(DrawCardsActivePlayerEffect effect) {
        super(effect);
        this.amount = effect.amount.copy();
    }

    @Override
    public DrawCardsActivePlayerEffect copy() {
        return new DrawCardsActivePlayerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null) {
            return false;
        }
        if (!cPlane.getPlaneType().equals((Object)Planes.PLANE_ACADEMY_AT_TOLARIA_WEST)) {
            return false;
        }
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null) {
            player.drawCards(this.amount.calculate(game, source, this), source, game);
            return true;
        }
        return false;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append("draw ").append(CardUtil.numberToText(this.amount.toString())).append(" cards");
        this.staticText = sb.toString();
    }
}

