/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Planes;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;

class HedronFieldsOfAgadeemRestrictionEffect
extends RestrictionEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures with power 7 or greater");

    public HedronFieldsOfAgadeemRestrictionEffect() {
        super(Duration.Custom);
        this.staticText = "Creatures with power 7 or greater can't attack or block";
    }

    protected HedronFieldsOfAgadeemRestrictionEffect(HedronFieldsOfAgadeemRestrictionEffect effect) {
        super(effect);
    }

    @Override
    public HedronFieldsOfAgadeemRestrictionEffect copy() {
        return new HedronFieldsOfAgadeemRestrictionEffect(this);
    }

    @Override
    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null) {
            return false;
        }
        if (!cPlane.getPlaneType().equals((Object)Planes.PLANE_HEDRON_FIELDS_OF_AGADEEM)) {
            return false;
        }
        return filter.match(permanent, source.getControllerId(), source, game);
    }

    static {
        filter.add(new PowerPredicate(ComparisonType.MORE_THAN, 6));
    }
}

