/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Planes;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;

class TazeemCantBlockAllEffect
extends RestrictionEffect {
    TazeemCantBlockAllEffect() {
        super(Duration.Custom);
        this.staticText = "creatures can't block";
    }

    protected TazeemCantBlockAllEffect(TazeemCantBlockAllEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null || !cPlane.getPlaneType().equals((Object)Planes.PLANE_TAZEEM)) {
            return false;
        }
        return StaticFilters.FILTER_PERMANENT_CREATURES.match(permanent, source.getControllerId(), source, game);
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public TazeemCantBlockAllEffect copy() {
        return new TazeemCantBlockAllEffect(this);
    }
}

