/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.ArrayList;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MainPhaseStackEmptyCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RollPlanarDieEffect;
import mage.abilities.effects.common.cost.PlanarDieRollCostIncreasingEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.constants.CardType;
import mage.constants.Planes;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.command.Plane;
import mage.game.command.planes.TrailOfTheMageRingsReboundEffect;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.watchers.common.PlanarRollWatcher;

public class TrailOfTheMageRingsPlane
extends Plane {
    private static final FilterCard filter = new FilterCard("creature spells");

    public TrailOfTheMageRingsPlane() {
        this.setPlaneType(Planes.PLANE_TRAIL_OF_THE_MAGE_RINGS);
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.COMMAND, new TrailOfTheMageRingsReboundEffect());
        this.getAbilities().add(ability);
        SearchLibraryPutInHandEffect chaosEffect = new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, 1, (FilterCard)new FilterInstantOrSorceryCard()), true);
        Object chaosTarget = null;
        ArrayList<Effect> chaosEffects = new ArrayList<Effect>();
        chaosEffects.add(chaosEffect);
        ArrayList<Target> chaosTargets = new ArrayList<Target>();
        chaosTargets.add((Target)chaosTarget);
        ActivateIfConditionActivatedAbility chaosAbility = new ActivateIfConditionActivatedAbility(Zone.COMMAND, new RollPlanarDieEffect(chaosEffects, chaosTargets), new GenericManaCost(0), MainPhaseStackEmptyCondition.instance);
        chaosAbility.addWatcher(new PlanarRollWatcher());
        this.getAbilities().add(chaosAbility);
        chaosAbility.setMayActivate(TargetController.ANY);
        this.getAbilities().add(new SimpleStaticAbility(Zone.ALL, new PlanarDieRollCostIncreasingEffect(chaosAbility.getOriginalId())));
    }

    private TrailOfTheMageRingsPlane(TrailOfTheMageRingsPlane plane) {
        super(plane);
    }

    @Override
    public TrailOfTheMageRingsPlane copy() {
        return new TrailOfTheMageRingsPlane(this);
    }

    static {
        filter.add(CardType.CREATURE.getPredicate());
    }
}

