/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ReboundAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class TrailOfTheMageRingsReboundEffect
extends ContinuousEffectImpl {
    protected static final FilterCard filter = new FilterCard("Instant and sorcery spells");

    public TrailOfTheMageRingsReboundEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Instant and sorcery spells have rebound";
    }

    protected TrailOfTheMageRingsReboundEffect(TrailOfTheMageRingsReboundEffect effect) {
        super(effect);
    }

    @Override
    public TrailOfTheMageRingsReboundEffect copy() {
        return new TrailOfTheMageRingsReboundEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null) {
            return false;
        }
        if (!cPlane.getPlaneType().equals((Object)Planes.PLANE_TRAIL_OF_THE_MAGE_RINGS)) {
            return false;
        }
        for (UUID playerId : game.getPlayers().keySet()) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (Card card : player.getHand().getCards(filter, game)) {
                this.addReboundAbility(card, source, game);
            }
            for (StackObject stackObject : game.getStack()) {
                Spell spell;
                Card card;
                if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(source.getControllerId()) || (card = (spell = (Spell)stackObject).getCard()) == null) continue;
                this.addReboundAbility(card, source, game);
            }
        }
        return true;
    }

    private void addReboundAbility(Card card, Ability source, Game game) {
        boolean found;
        if (filter.match(card, game) && !(found = card.getAbilities(game).containsClass(ReboundAbility.class))) {
            ReboundAbility ability = new ReboundAbility();
            game.getState().addOtherAbility(card, ability);
        }
    }

    static {
        filter.add(Predicates.or(CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate()));
    }
}

