/*
 * Decompiled with CFR 0.152.
 */
package mage.game.draft;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mage.ObjectColor;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.Rarity;
import mage.util.RandomUtil;

public class ReshuffledSet
implements Serializable {
    protected final int numBoosterCommons;
    protected final int numBoosterUncommons;
    protected final int numBoosterRares;
    protected final int numBoosterSpecials;
    protected final List<CardInfo> commons;
    protected final List<CardInfo> uncommons;
    protected final List<CardInfo> rares;
    protected final List<CardInfo> mythics;
    protected final List<CardInfo> specials;
    protected final double chanceMythic;

    public ReshuffledSet(List<ExpansionSet> sets, int c, int u, int r) {
        this(sets, c, u, r, 0);
    }

    public ReshuffledSet(List<ExpansionSet> sets, int c, int u, int r, int special) {
        this.numBoosterCommons = c;
        this.numBoosterUncommons = u;
        this.numBoosterRares = r;
        this.numBoosterSpecials = special;
        this.commons = new ArrayList<CardInfo>();
        this.uncommons = new ArrayList<CardInfo>();
        this.rares = new ArrayList<CardInfo>();
        this.mythics = new ArrayList<CardInfo>();
        this.specials = new ArrayList<CardInfo>();
        for (ExpansionSet set : sets) {
            this.commons.addAll(this.findCardsBySetAndRarity(set, Rarity.COMMON));
            this.uncommons.addAll(this.findCardsBySetAndRarity(set, Rarity.UNCOMMON));
            this.rares.addAll(this.findCardsBySetAndRarity(set, Rarity.RARE));
            this.mythics.addAll(this.findCardsBySetAndRarity(set, Rarity.MYTHIC));
        }
        float nMythics = this.mythics.size();
        float nRares = this.rares.size();
        this.chanceMythic = nMythics / (nMythics + nRares + nRares);
    }

    protected List<CardInfo> findCardsBySetAndRarity(ExpansionSet set, Rarity rarity) {
        List<CardInfo> cardInfos = CardRepository.instance.findCards(new CardCriteria().setCodes(set.getCode()).rarities(rarity).maxCardNumber(set.getMaxCardNumberInBooster()));
        cardInfos.removeIf(next -> next.getCardNumber().contains("*") || next.getCardNumber().contains("+"));
        return cardInfos;
    }

    public List<Card> createBooster() {
        ArrayList<Card> booster = new ArrayList<Card>();
        booster.addAll(this.generateCommons());
        booster.addAll(this.generateUncommons());
        booster.addAll(this.generateRares());
        return booster;
    }

    protected void addToBooster(List<Card> booster, List<CardInfo> cards) {
        if (cards.isEmpty()) {
            return;
        }
        CardInfo cardInfo = cards.remove(RandomUtil.nextInt(cards.size()));
        Card card = cardInfo.createCard();
        if (card == null) {
            return;
        }
        booster.add(card);
    }

    protected List<Card> generateCommons() {
        ArrayList<Card> boosterCommons = new ArrayList<Card>();
        for (int i = 0; i < 100; ++i) {
            boosterCommons.clear();
            ArrayList<CardInfo> commonsForGenerate = new ArrayList<CardInfo>(this.commons);
            for (int j = 0; j < this.numBoosterCommons; ++j) {
                this.addToBooster(boosterCommons, commonsForGenerate);
            }
            if (!this.validateCommonColors(boosterCommons)) continue;
            return boosterCommons;
        }
        return boosterCommons;
    }

    protected List<Card> generateUncommons() {
        ArrayList<Card> boosterUncommons = new ArrayList<Card>();
        for (int i = 0; i < 100; ++i) {
            boosterUncommons.clear();
            ArrayList<CardInfo> uncommonsForGenerate = new ArrayList<CardInfo>(this.uncommons);
            for (int j = 0; j < this.numBoosterUncommons; ++j) {
                this.addToBooster(boosterUncommons, uncommonsForGenerate);
            }
            if (!this.validateUncommonColors(boosterUncommons)) continue;
            return boosterUncommons;
        }
        return boosterUncommons;
    }

    protected List<Card> generateRares() {
        ArrayList<Card> boosterRares = new ArrayList<Card>();
        ArrayList<CardInfo> raresForGenerate = new ArrayList<CardInfo>(this.rares);
        ArrayList<CardInfo> mythicsForGenerate = new ArrayList<CardInfo>(this.mythics);
        for (int j = 0; j < this.numBoosterRares; ++j) {
            if (RandomUtil.nextDouble() < this.chanceMythic) {
                this.addToBooster(boosterRares, mythicsForGenerate);
                continue;
            }
            this.addToBooster(boosterRares, raresForGenerate);
        }
        return boosterRares;
    }

    protected boolean validateCommonColors(List<Card> booster) {
        List commonColors = booster.stream().filter(card -> card.getRarity() == Rarity.COMMON).map(ExpansionSet::getColorForValidate).collect(Collectors.toList());
        ObjectColor colorsRepresented = new ObjectColor();
        HashSet<ObjectColor> colorCombinations = new HashSet<ObjectColor>();
        int colorlessCountPlusOne = 1;
        for (ObjectColor color : commonColors) {
            colorCombinations.add(color);
            int colorCount = color.getColorCount();
            if (colorCount == 0) {
                ++colorlessCountPlusOne;
                continue;
            }
            if (colorCount > 1) {
                List<ObjectColor> multiColor = color.getColors();
                colorsRepresented.addColor(multiColor.get(RandomUtil.nextInt(multiColor.size())));
                continue;
            }
            colorsRepresented.addColor(color);
        }
        int colors = Math.min(colorsRepresented.getColorCount(), colorCombinations.size());
        if (colors >= Math.min(5, commonColors.size() - colorlessCountPlusOne)) {
            return true;
        }
        if (colors < 4) {
            return false;
        }
        return RandomUtil.nextDouble() > Math.pow(0.8, colorlessCountPlusOne);
    }

    protected boolean validateUncommonColors(List<Card> booster) {
        List uncommonColors = booster.stream().filter(card -> card.getRarity() == Rarity.UNCOMMON).map(ExpansionSet::getColorForValidate).collect(Collectors.toList());
        if (uncommonColors.size() < 3) {
            return true;
        }
        if (uncommonColors.contains(ObjectColor.COLORLESS)) {
            return true;
        }
        return new HashSet(uncommonColors).size() > 1;
    }
}

