/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.game.events.GameEvent;

public abstract class BatchEvent<T extends GameEvent>
extends GameEvent {
    private final Set<T> events = new HashSet<T>();
    private final boolean singleTargetId;
    private final boolean singleSourceId;
    private final boolean singlePlayerId;

    protected BatchEvent(GameEvent.EventType eventType, boolean singleTargetId, boolean singleSourceId, boolean singlePlayerId, T firstEvent) {
        super(eventType, singleTargetId ? ((GameEvent)firstEvent).getTargetId() : null, null, singlePlayerId ? ((GameEvent)firstEvent).getPlayerId() : null);
        this.singleTargetId = singleTargetId;
        this.singleSourceId = singleSourceId;
        this.singlePlayerId = singlePlayerId;
        this.setSourceId(singleSourceId ? ((GameEvent)firstEvent).getSourceId() : null);
        if (firstEvent instanceof BatchEvent) {
            throw new UnsupportedOperationException("Wrong code usage: nesting batch events not supported");
        }
        if (!eventType.isBatch()) {
            throw new IllegalArgumentException("Wrong code usage: batch event should use batch EventType: " + (Object)((Object)eventType));
        }
        this.addEvent(firstEvent);
    }

    protected BatchEvent(GameEvent.EventType eventType) {
        super(eventType, null, null, null);
        this.singleTargetId = false;
        this.singleSourceId = false;
        this.singlePlayerId = false;
        if (!eventType.isBatch()) {
            throw new IllegalArgumentException("Wrong code usage: batch event should use batch EventType: " + (Object)((Object)eventType));
        }
    }

    public void addEvent(T event) {
        if (this.singleTargetId && !this.getTargetId().equals(((GameEvent)event).getTargetId())) {
            throw new IllegalStateException("Wrong code usage. Batch event initiated with single target id, but trying to add event with different target id");
        }
        if (this.singleSourceId && !this.getSourceId().equals(((GameEvent)event).getSourceId())) {
            throw new IllegalStateException("Wrong code usage. Batch event initiated with single source id, but trying to add event with different source id");
        }
        if (this.singlePlayerId && !this.getPlayerId().equals(((GameEvent)event).getPlayerId())) {
            throw new IllegalStateException("Wrong code usage. Batch event initiated with single player id, but trying to add event with different player id");
        }
        this.events.add(event);
    }

    public Set<T> getEvents() {
        return this.events;
    }

    public Set<UUID> getTargetIds() {
        return this.events.stream().map(GameEvent::getTargetId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<UUID> getSourceIds() {
        return this.events.stream().map(GameEvent::getSourceId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<UUID> getPlayerIds() {
        return this.events.stream().map(GameEvent::getPlayerId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public int getAmount() {
        return this.events.stream().mapToInt(GameEvent::getAmount).sum();
    }

    @Override
    public UUID getTargetId() {
        if (this.singleTargetId) {
            return super.getTargetId();
        }
        throw new IllegalStateException("Wrong code usage. Must search value from a getEvents list or use CardUtil.getEventTargets(event)");
    }

    @Override
    public UUID getSourceId() {
        if (this.singleSourceId) {
            return super.getSourceId();
        }
        throw new IllegalStateException("Wrong code usage. Must search value from a getEvents list");
    }

    @Override
    public UUID getPlayerId() {
        if (this.singlePlayerId) {
            return super.getPlayerId();
        }
        throw new IllegalStateException("Wrong code usage. Must search value from a getEvents list");
    }
}

