/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;

public class CreateTokenEvent
extends GameEvent {
    private final Map<Token, Integer> tokens = new HashMap<Token, Integer>();

    public CreateTokenEvent(Ability source, UUID controllerId, int amount, List<Token> tokensList) {
        super(GameEvent.EventType.CREATE_TOKEN, null, source, controllerId, amount, false);
        if (tokensList != null) {
            for (Token token : tokensList) {
                this.tokens.put(token, amount);
            }
        }
    }

    public Map<Token, Integer> getTokens() {
        return this.tokens;
    }

    public void multiplyTokens(int factor) {
        this.multiplyTokens(factor, null);
    }

    public void multiplyTokens(int factor, ConditionOnToken condition) {
        for (Map.Entry<Token, Integer> entry : this.tokens.entrySet()) {
            if (condition != null && !condition.apply(entry.getKey())) continue;
            entry.setValue(entry.getValue() * factor);
        }
    }

    @Override
    public int getAmount() {
        int amount = 0;
        for (Integer num : this.tokens.values()) {
            amount += num.intValue();
        }
        return amount;
    }

    @Override
    public void setAmount(int amount) {
        throw new UnsupportedOperationException("Do not use event.setAmount for tokens. Amount must be set individually in event.getTokens");
    }

    public static interface ConditionOnToken {
        public boolean apply(Token var1);
    }
}

