/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class DefenderAttackedEvent
extends GameEvent {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    public DefenderAttackedEvent(UUID targetId, UUID playerId) {
        super(GameEvent.EventType.DEFENDER_ATTACKED, targetId, null, playerId);
    }

    public static void makeAddEvents(Map<UUID, Set<MageObjectReference>> morMapSet, UUID attackingPlayerId, Game game) {
        for (Map.Entry<UUID, Set<MageObjectReference>> entry : morMapSet.entrySet()) {
            DefenderAttackedEvent event = new DefenderAttackedEvent(entry.getKey(), attackingPlayerId);
            event.morSet.addAll((Collection<MageObjectReference>)entry.getValue());
            game.addSimultaneousEvent(event);
        }
    }

    public List<Permanent> getAttackers(Game game) {
        return this.morSet.stream().map(mor -> mor.getPermanent(game)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

