/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.io.Serializable;
import java.util.UUID;
import mage.cards.Cards;
import mage.cards.decks.Deck;
import mage.game.Game;
import mage.game.draft.Draft;
import mage.game.events.EventDispatcher;
import mage.game.events.EventSource;
import mage.game.events.Listener;
import mage.game.events.TableEvent;
import mage.game.match.MatchOptions;
import mage.game.tournament.MultiplayerRound;
import mage.game.tournament.TournamentPairing;

public class TableEventSource
implements EventSource<TableEvent>,
Serializable {
    protected final EventDispatcher<TableEvent> dispatcher = new EventDispatcher<TableEvent>(){};

    @Override
    public void addListener(Listener<TableEvent> listener) {
        this.dispatcher.addListener(listener);
    }

    @Override
    public void removeListener(Listener<TableEvent> listener) {
        this.dispatcher.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this.dispatcher.removeAllListener();
    }

    public void fireTableEvent(TableEvent.EventType eventType) {
        this.dispatcher.fireEvent(new TableEvent(eventType));
    }

    public void fireTableEvent(TableEvent.EventType eventType, String message, Game game) {
        this.dispatcher.fireEvent(new TableEvent(eventType, message, game));
    }

    public void fireTableEvent(TableEvent.EventType eventType, String message, boolean withTime, boolean withTurnInfo, Game game) {
        this.dispatcher.fireEvent(new TableEvent(eventType, message, withTime, withTurnInfo, game));
    }

    public void fireTableEvent(TableEvent.EventType eventType, UUID playerId, String message, Game game) {
        this.dispatcher.fireEvent(new TableEvent(eventType, playerId, message, game));
    }

    public void fireTableEvent(TableEvent.EventType eventType, String message, Exception ex, Game game) {
        this.dispatcher.fireEvent(new TableEvent(eventType, message, ex, game));
    }

    public void fireTableEvent(TableEvent.EventType eventType, String message, Draft draft) {
        this.dispatcher.fireEvent(new TableEvent(eventType, message, draft));
    }

    public void fireTableEvent(TableEvent.EventType eventType, String message, Cards cards, Game game) {
        this.dispatcher.fireEvent(new TableEvent(eventType, message, cards, game));
    }

    public void fireTableEvent(TableEvent.EventType eventType, UUID playerId, Deck deck, int timeout) {
        this.dispatcher.fireEvent(new TableEvent(eventType, playerId, deck, timeout));
    }

    public void fireTableEvent(TableEvent.EventType eventType, TournamentPairing pair, MatchOptions options) {
        this.dispatcher.fireEvent(new TableEvent(eventType, pair, options));
    }

    public void fireTableEvent(TableEvent.EventType eventType, MultiplayerRound round, MatchOptions options) {
        this.dispatcher.fireEvent(new TableEvent(eventType, round, options));
    }
}

