/*
 * Decompiled with CFR 0.152.
 */
package mage.game.match;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mage.cards.decks.DeckCardInfo;
import mage.constants.MatchBufferTime;
import mage.constants.MatchTimeLimit;
import mage.constants.MultiplayerAttackOption;
import mage.constants.RangeOfInfluence;
import mage.constants.SkillLevel;
import mage.game.mulligan.MulliganType;
import mage.game.result.ResultProtos;
import mage.players.PlayerType;

public class MatchOptions
implements Serializable {
    protected String name;
    protected MultiplayerAttackOption attackOption = MultiplayerAttackOption.LEFT;
    protected RangeOfInfluence range = RangeOfInfluence.ALL;
    protected int winsNeeded;
    protected int freeMulligans;
    protected boolean customStartLifeEnabled;
    protected int customStartLife;
    protected boolean customStartHandSizeEnabled;
    protected int customStartHandSize;
    protected String gameType;
    protected String deckType;
    protected boolean limited;
    protected List<PlayerType> playerTypes = new ArrayList<PlayerType>();
    protected boolean multiPlayer;
    protected String password;
    protected SkillLevel skillLevel = SkillLevel.CASUAL;
    protected boolean rollbackTurnsAllowed;
    protected boolean spectatorsAllowed;
    protected boolean planeChase;
    protected int quitRatio;
    protected int minimumRating;
    protected int edhPowerLevel;
    protected boolean rated;
    protected Set<String> bannedUsers = new HashSet<String>();
    protected MatchTimeLimit matchTimeLimit = MatchTimeLimit.NONE;
    protected MatchBufferTime matchBufferTime = MatchBufferTime.NONE;
    protected MulliganType mulliganType = MulliganType.GAME_DEFAULT;
    protected Collection<DeckCardInfo> perPlayerEmblemCards = Collections.emptySet();
    protected Collection<DeckCardInfo> globalEmblemCards = Collections.emptySet();

    public MatchOptions(String name, String gameType, boolean multiPlayer) {
        this.name = name;
        this.gameType = gameType;
        this.password = "";
        this.multiPlayer = multiPlayer;
    }

    public boolean isSingleGameTourney() {
        return this.multiPlayer;
    }

    public String getName() {
        return this.name;
    }

    public MultiplayerAttackOption getAttackOption() {
        return this.attackOption;
    }

    public void setAttackOption(MultiplayerAttackOption attackOption) {
        this.attackOption = attackOption;
    }

    public RangeOfInfluence getRange() {
        return this.range;
    }

    public void setRange(RangeOfInfluence range) {
        this.range = range;
    }

    public int getWinsNeeded() {
        return this.winsNeeded;
    }

    public void setWinsNeeded(int winsNeeded) {
        this.winsNeeded = winsNeeded;
    }

    public int getFreeMulligans() {
        return this.freeMulligans;
    }

    public void setFreeMulligans(int freeMulligans) {
        this.freeMulligans = freeMulligans;
    }

    public boolean isCustomStartLifeEnabled() {
        return this.customStartLifeEnabled;
    }

    public void setCustomStartLifeEnabled(boolean value) {
        this.customStartLifeEnabled = value;
    }

    public int getCustomStartLife() {
        return this.customStartLife;
    }

    public void setCustomStartLife(int startLife) {
        this.customStartLife = startLife;
    }

    public boolean isCustomStartHandSizeEnabled() {
        return this.customStartHandSizeEnabled;
    }

    public void setCustomStartHandSizeEnabled(boolean value) {
        this.customStartHandSizeEnabled = value;
    }

    public int getCustomStartHandSize() {
        return this.customStartHandSize;
    }

    public void setCustomStartHandSize(int startHandSize) {
        this.customStartHandSize = startHandSize;
    }

    public String getGameType() {
        return this.gameType;
    }

    public void setGameType(String gameType) {
        this.gameType = gameType;
    }

    public String getDeckType() {
        return this.deckType;
    }

    public void setDeckType(String deckType) {
        this.deckType = deckType;
    }

    public List<PlayerType> getPlayerTypes() {
        return this.playerTypes;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public MatchTimeLimit getMatchTimeLimit() {
        return this.matchTimeLimit;
    }

    public void setMatchTimeLimit(MatchTimeLimit matchTimeLimit) {
        this.matchTimeLimit = Optional.ofNullable(matchTimeLimit).orElse(MatchTimeLimit.NONE);
    }

    public MatchBufferTime getMatchBufferTime() {
        return this.matchBufferTime;
    }

    public void setMatchBufferTime(MatchBufferTime matchBufferTime) {
        this.matchBufferTime = Optional.ofNullable(matchBufferTime).orElse(MatchBufferTime.NONE);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SkillLevel getSkillLevel() {
        return this.skillLevel;
    }

    public void setSkillLevel(SkillLevel skillLevel) {
        this.skillLevel = skillLevel;
    }

    public boolean isRollbackTurnsAllowed() {
        return this.rollbackTurnsAllowed;
    }

    public void setRollbackTurnsAllowed(boolean rollbackTurnsAllowed) {
        this.rollbackTurnsAllowed = rollbackTurnsAllowed;
    }

    public boolean isSpectatorsAllowed() {
        return this.spectatorsAllowed;
    }

    public void setSpectatorsAllowed(boolean spectatorsAllowed) {
        this.spectatorsAllowed = spectatorsAllowed;
    }

    public boolean isPlaneChase() {
        return this.planeChase;
    }

    public void setPlaneChase(boolean planeChase) {
        this.planeChase = planeChase;
    }

    public int getQuitRatio() {
        return this.quitRatio;
    }

    public void setQuitRatio(int quitRatio) {
        this.quitRatio = quitRatio;
    }

    public int getMinimumRating() {
        return this.minimumRating;
    }

    public void setMinimumRating(int minimumRating) {
        this.minimumRating = minimumRating;
    }

    public int getEdhPowerLevel() {
        return this.edhPowerLevel;
    }

    public void setEdhPowerLevel(int edhPowerLevel) {
        this.edhPowerLevel = edhPowerLevel;
    }

    public boolean isRated() {
        return this.rated;
    }

    public void setRated(boolean rated) {
        this.rated = rated;
    }

    public Set<String> getBannedUsers() {
        return this.bannedUsers;
    }

    public void setBannedUsers(Set<String> bannedUsers) {
        this.bannedUsers = bannedUsers;
    }

    public ResultProtos.MatchOptionsProto toProto() {
        ResultProtos.SkillLevel skillLevel;
        ResultProtos.MatchOptionsProto.Builder builder = ResultProtos.MatchOptionsProto.newBuilder().setName(this.getName()).setLimited(this.isLimited()).setRated(this.isRated()).setWinsNeeded(this.getWinsNeeded());
        switch (this.getSkillLevel()) {
            default: {
                skillLevel = ResultProtos.SkillLevel.BEGINNER;
                break;
            }
            case CASUAL: {
                skillLevel = ResultProtos.SkillLevel.CASUAL;
                break;
            }
            case SERIOUS: {
                skillLevel = ResultProtos.SkillLevel.SERIOUS;
            }
        }
        builder.setSkillLevel(skillLevel);
        return builder.build();
    }

    public void setMullgianType(MulliganType mulliganType) {
        this.mulliganType = Optional.ofNullable(mulliganType).orElse(MulliganType.GAME_DEFAULT);
    }

    public MulliganType getMulliganType() {
        return this.mulliganType;
    }

    public Collection<DeckCardInfo> getPerPlayerEmblemCards() {
        return this.perPlayerEmblemCards;
    }

    public void setPerPlayerEmblemCards(Collection<DeckCardInfo> perPlayerEmblemCards) {
        this.perPlayerEmblemCards = perPlayerEmblemCards;
    }

    public Collection<DeckCardInfo> getGlobalEmblemCards() {
        return this.globalEmblemCards;
    }

    public void setGlobalEmblemCards(Collection<DeckCardInfo> globalEmblemCards) {
        this.globalEmblemCards = globalEmblemCards;
    }
}

