/*
 * Decompiled with CFR 0.152.
 */
package mage.game.mulligan;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import mage.game.Game;
import mage.game.mulligan.VancouverMulligan;
import mage.players.Player;

public class CanadianHighlanderMulligan
extends VancouverMulligan {
    protected Map<UUID, String> usedMulligans = new LinkedHashMap<UUID, String>();

    public CanadianHighlanderMulligan(int freeMulligans) {
        super(freeMulligans);
    }

    CanadianHighlanderMulligan(CanadianHighlanderMulligan mulligan) {
        super(mulligan);
        this.usedMulligans.putAll(mulligan.usedMulligans);
    }

    private String getNextMulligan(String mulligan) {
        switch (mulligan) {
            case "7": {
                return "6a";
            }
            case "6a": {
                return "6b";
            }
            case "6b": {
                return "5a";
            }
            case "5a": {
                return "5b";
            }
            case "5b": {
                return "4a";
            }
            case "4a": {
                return "4b";
            }
            case "4b": {
                return "3a";
            }
            case "3a": {
                return "3b";
            }
            case "3b": {
                return "2a";
            }
            case "2a": {
                return "2b";
            }
            case "2b": {
                return "1a";
            }
            case "1a": {
                return "1b";
            }
        }
        return "0";
    }

    private int getNextMulliganNum(String mulligan) {
        switch (mulligan) {
            case "7": {
                return 6;
            }
            case "6a": {
                return 6;
            }
            case "6b": {
                return 5;
            }
            case "5a": {
                return 5;
            }
            case "5b": {
                return 4;
            }
            case "4a": {
                return 4;
            }
            case "4b": {
                return 3;
            }
            case "3a": {
                return 3;
            }
            case "3b": {
                return 2;
            }
            case "2a": {
                return 2;
            }
            case "2b": {
                return 1;
            }
            case "1a": {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int mulliganDownTo(Game game, UUID playerId) {
        Player player = game.getPlayer(playerId);
        int deduction = 1;
        int numToMulliganTo = -1;
        if (this.usedMulligans != null) {
            String mulliganCode = "7";
            if (this.usedMulligans.containsKey(player.getId())) {
                mulliganCode = this.usedMulligans.get(player.getId());
            }
            numToMulliganTo = this.getNextMulliganNum(mulliganCode);
        }
        if (numToMulliganTo == -1) {
            return player.getHand().size() - deduction;
        }
        return numToMulliganTo;
    }

    @Override
    public void mulligan(Game game, UUID playerId) {
        int numCards;
        Player player = game.getPlayer(playerId);
        int numToMulliganTo = numCards = player.getHand().size();
        player.getLibrary().addAll(player.getHand().getCards(game), game);
        player.getHand().clear();
        player.shuffleLibrary(null, game);
        if (this.usedMulligans != null) {
            String mulliganCode = "7";
            if (this.usedMulligans.containsKey(player.getId())) {
                mulliganCode = this.usedMulligans.get(player.getId());
            }
            numToMulliganTo = this.getNextMulliganNum(mulliganCode);
            this.usedMulligans.put(player.getId(), this.getNextMulligan(mulliganCode));
        }
        game.fireInformEvent(player.getLogName() + " mulligans to " + numToMulliganTo + (numToMulliganTo == 1 ? " card" : " cards"));
        player.drawCards(numToMulliganTo, null, game);
    }

    @Override
    public CanadianHighlanderMulligan copy() {
        return new CanadianHighlanderMulligan(this);
    }
}

