/*
 * Decompiled with CFR 0.152.
 */
package mage.game.mulligan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.mulligan.MulliganDefaultHandSorter;
import mage.players.Player;

public abstract class Mulligan
implements Serializable {
    protected final int freeMulligans;
    protected final Map<UUID, Integer> usedFreeMulligans = new HashMap<UUID, Integer>();

    Mulligan(int freeMulligans) {
        this.freeMulligans = freeMulligans;
    }

    Mulligan(Mulligan mulligan) {
        this.freeMulligans = mulligan.freeMulligans;
        this.usedFreeMulligans.putAll(mulligan.usedFreeMulligans);
    }

    public void executeMulliganPhase(Game game, int startingHandSize) {
        ArrayList<UUID> keepPlayers = new ArrayList<UUID>();
        ArrayList<UUID> mulliganPlayers = new ArrayList<UUID>();
        do {
            mulliganPlayers.clear();
            for (UUID playerId : game.getState().getPlayerList(game.getStartingPlayerId())) {
                if (keepPlayers.contains(playerId)) continue;
                Player player = game.getPlayer(playerId);
                boolean keep = true;
                while (this.canTakeMulligan(game, player)) {
                    GameEvent event = new GameEvent(GameEvent.EventType.CAN_TAKE_MULLIGAN, null, null, playerId);
                    if (game.replaceEvent(event)) continue;
                    game.fireEvent(event);
                    game.getState().setChoosingPlayerId(playerId);
                    if (!player.chooseMulligan(game)) break;
                    keep = false;
                    break;
                }
                if (keep) {
                    game.endMulligan(player.getId());
                    keepPlayers.add(playerId);
                    game.fireInformEvent(player.getLogName() + " keeps hand");
                    continue;
                }
                mulliganPlayers.add(playerId);
                game.fireInformEvent(player.getLogName() + " decides to take mulligan");
            }
            for (UUID mulliganPlayerId : mulliganPlayers) {
                this.mulligan(game, mulliganPlayerId);
            }
            game.saveState(false);
        } while (!mulliganPlayers.isEmpty());
    }

    public abstract int mulliganDownTo(Game var1, UUID var2);

    public abstract void mulligan(Game var1, UUID var2);

    public abstract void endMulligan(Game var1, UUID var2);

    public abstract Mulligan copy();

    public boolean canTakeMulligan(Game game, Player player) {
        return !player.getHand().isEmpty();
    }

    public int getFreeMulligans() {
        return this.freeMulligans;
    }

    public void drawHand(int numCards, Player player, Game game) {
        player.drawCards(numCards, null, game);
        player.getHand().sortCards(game, new MulliganDefaultHandSorter());
    }
}

