/*
 * Decompiled with CFR 0.152.
 */
package mage.game.mulligan;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.game.Game;
import mage.game.mulligan.LondonMulligan;
import mage.game.mulligan.MulliganDefaultHandSorter;
import mage.players.Player;
import mage.util.RandomUtil;

public class SmoothedLondonMulligan
extends LondonMulligan {
    public SmoothedLondonMulligan(int freeMulligans) {
        super(freeMulligans);
    }

    SmoothedLondonMulligan(SmoothedLondonMulligan mulligan) {
        super(mulligan);
    }

    private static double countLands(Collection<Card> cards, boolean library) {
        double land_count = 0.0;
        for (Card card : cards) {
            if (card.isLand()) {
                land_count += 1.0;
                continue;
            }
            if (!(card instanceof ModalDoubleFacedCard) || !((ModalDoubleFacedCard)card).getRightHalfCard().isLand()) continue;
            if (library) {
                land_count += 0.5;
                continue;
            }
            if (!RandomUtil.nextBoolean()) continue;
            land_count += 1.0;
        }
        return land_count;
    }

    @Override
    public void drawHand(int numCards, Player player, Game game) {
        List<Card> library = player.getLibrary().getCards(game);
        if (library.size() >= numCards * 2 && numCards > 1) {
            double land_ratio = SmoothedLondonMulligan.countLands(library, true) / (double)library.size();
            Set<Card> hand1 = player.getLibrary().getTopCards(game, numCards);
            Set<Card> hand2 = player.getLibrary().getTopCards(game, numCards * 2);
            hand2.removeAll(hand1);
            double hand1_ratio = SmoothedLondonMulligan.countLands(hand1, false) / (double)numCards;
            double hand2_ratio = SmoothedLondonMulligan.countLands(hand2, false) / (double)numCards;
            double hand1_distance = Math.max(0.0, Math.abs(land_ratio - hand1_ratio) - 0.15) + RandomUtil.nextDouble() * 0.3;
            double hand2_distance = Math.max(0.0, Math.abs(land_ratio - hand2_ratio) - 0.15) + RandomUtil.nextDouble() * 0.3;
            if (hand1_distance < hand2_distance) {
                player.drawCards(numCards, null, game);
                player.putCardsOnBottomOfLibrary(new CardsImpl(hand2), game, null, false);
            } else {
                player.putCardsOnBottomOfLibrary(new CardsImpl(hand1), game, null, false);
                player.drawCards(numCards, null, game);
            }
            player.shuffleLibrary(null, game);
        } else {
            player.drawCards(numCards, null, game);
        }
        player.getHand().sortCards(game, new MulliganDefaultHandSorter());
    }

    @Override
    public SmoothedLondonMulligan copy() {
        return new SmoothedLondonMulligan(this);
    }
}

