/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.keyword.PhasingAbility;
import mage.constants.CardType;
import mage.constants.RangeOfInfluence;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.PlayerList;

public class Battlefield
implements Serializable {
    private final Map<UUID, Permanent> field = new LinkedHashMap<UUID, Permanent>();

    public Battlefield() {
    }

    protected Battlefield(Battlefield battlefield) {
        for (Map.Entry<UUID, Permanent> entry : battlefield.field.entrySet()) {
            this.field.put(entry.getKey(), entry.getValue().copy());
        }
    }

    public Battlefield copy() {
        return new Battlefield(this);
    }

    public void reset(Game game) {
        for (Permanent perm : this.field.values()) {
            perm.reset(game);
        }
    }

    public void clear() {
        this.field.clear();
    }

    public int countAll(FilterPermanent filter, UUID controllerId, Game game) {
        return (int)this.field.values().stream().filter(permanent -> permanent.isControlledBy(controllerId) && filter.match(permanent, game) && permanent.isPhasedIn()).count();
    }

    public int count(FilterPermanent filter, UUID sourcePlayerId, Ability source, Game game) {
        if (game.getRangeOfInfluence() == RangeOfInfluence.ALL) {
            return (int)this.field.values().stream().filter(permanent -> filter.match((Permanent)permanent, sourcePlayerId, source, game) && permanent.isPhasedIn()).count();
        }
        PlayerList range = game.getState().getPlayersInRange(sourcePlayerId, game);
        return (int)this.field.values().stream().filter(permanent -> range.contains(permanent.getControllerId()) && filter.match((Permanent)permanent, sourcePlayerId, source, game) && permanent.isPhasedIn()).count();
    }

    public boolean containsControlled(FilterPermanent filter, Ability source, Game game, int num) {
        return this.containsControlled(filter, source.getControllerId(), source, game, num);
    }

    public boolean containsControlled(FilterPermanent filter, UUID controllerId, Ability source, Game game, int num) {
        return this.field.values().stream().filter(permanent -> permanent.isControlledBy(controllerId) && filter.match((Permanent)permanent, controllerId, source, game) && permanent.isPhasedIn()).count() >= (long)num;
    }

    public boolean contains(FilterPermanent filter, Ability source, Game game, int num) {
        return this.contains(filter, source.getControllerId(), source, game, num);
    }

    public boolean contains(FilterPermanent filter, UUID sourcePlayerId, Ability source, Game game, int num) {
        if (game.getRangeOfInfluence() == RangeOfInfluence.ALL) {
            return this.field.values().stream().filter(permanent -> filter.match((Permanent)permanent, sourcePlayerId, source, game) && permanent.isPhasedIn()).count() >= (long)num;
        }
        PlayerList range = game.getState().getPlayersInRange(sourcePlayerId, game);
        return this.field.values().stream().filter(permanent -> range.contains(permanent.getControllerId()) && filter.match((Permanent)permanent, sourcePlayerId, source, game) && permanent.isPhasedIn()).count() >= (long)num;
    }

    public void addPermanent(Permanent permanent) {
        this.field.put(permanent.getId(), permanent);
    }

    public Permanent getPermanent(UUID key) {
        return this.field.get(key);
    }

    public void removePermanent(UUID key) {
        this.field.remove(key);
    }

    public boolean containsPermanent(UUID key) {
        return this.field.containsKey(key);
    }

    public void beginningOfTurn(Game game) {
        for (Permanent perm : this.field.values()) {
            perm.beginningOfTurn(game);
        }
    }

    public void endOfTurn(Game game) {
        for (Permanent perm : this.field.values()) {
            perm.endOfTurn(game);
        }
    }

    public Collection<Permanent> getAllPermanents() {
        return this.field.values();
    }

    public List<Permanent> getAllActivePermanents() {
        return this.field.values().stream().filter(Permanent::isPhasedIn).collect(Collectors.toList());
    }

    public List<Permanent> getAllActivePermanents(UUID controllerId) {
        return this.field.values().stream().filter(perm -> perm.isPhasedIn() && perm.isControlledBy(controllerId)).collect(Collectors.toList());
    }

    @Deprecated
    public List<Permanent> getAllActivePermanents(CardType type, Game game) {
        return this.field.values().stream().filter(perm -> perm.isPhasedIn() && perm.getCardType(game).contains((Object)type)).collect(Collectors.toList());
    }

    @Deprecated
    public List<Permanent> getAllActivePermanents(FilterPermanent filter, Game game) {
        return this.field.values().stream().filter(perm -> perm.isPhasedIn() && filter.match(perm, game)).collect(Collectors.toList());
    }

    public List<Permanent> getAllActivePermanents(FilterPermanent filter, UUID controllerId, Game game) {
        return this.field.values().stream().filter(perm -> perm.isPhasedIn() && perm.isControlledBy(controllerId) && filter.match(perm, game)).collect(Collectors.toList());
    }

    public List<Permanent> getActivePermanents(FilterPermanent filter, UUID sourcePlayerId, Game game) {
        return this.getActivePermanents(filter, sourcePlayerId, null, game);
    }

    public List<Permanent> getActivePermanents(FilterPermanent filter, UUID sourcePlayerId, Ability source, Game game) {
        if (game.getRangeOfInfluence() == RangeOfInfluence.ALL) {
            return this.field.values().stream().filter(perm -> perm.isPhasedIn() && filter.match((Permanent)perm, sourcePlayerId, source, game)).collect(Collectors.toList());
        }
        PlayerList range = game.getState().getPlayersInRange(sourcePlayerId, game);
        return this.field.values().stream().filter(perm -> perm.isPhasedIn() && range.contains(perm.getControllerId()) && filter.match((Permanent)perm, sourcePlayerId, source, game)).collect(Collectors.toList());
    }

    public List<Permanent> getActivePermanents(UUID sourcePlayerId, Game game) {
        if (game.getRangeOfInfluence() == RangeOfInfluence.ALL) {
            return this.getAllActivePermanents();
        }
        PlayerList range = game.getState().getPlayersInRange(sourcePlayerId, game);
        return this.field.values().stream().filter(perm -> perm.isPhasedIn() && range.contains(perm.getControllerId())).collect(Collectors.toList());
    }

    public List<Permanent> getPhasingOut(Game game, UUID controllerId) {
        return this.field.values().stream().filter(perm -> perm.hasAbility(PhasingAbility.getInstance(), game) && perm.isPhasedIn() && perm.isControlledBy(controllerId)).collect(Collectors.toList());
    }

    public List<Permanent> getPhasedOut(UUID controllerId) {
        return this.field.values().stream().filter(perm -> !perm.isPhasedIn() && perm.isControlledBy(controllerId)).collect(Collectors.toList());
    }

    public void resetPermanentsControl() {
        for (Permanent perm : this.field.values()) {
            if (!perm.isPhasedIn()) continue;
            perm.resetControl();
        }
    }

    public boolean fireControlChangeEvents(Game game) {
        boolean controlChanged = false;
        for (Permanent perm : this.field.values()) {
            if (!perm.isPhasedIn()) continue;
            controlChanged |= perm.checkControlChanged(game);
        }
        return controlChanged;
    }

    public int countTokens(UUID controllerId) {
        return this.field.values().stream().filter(Objects::nonNull).filter(PermanentToken.class::isInstance).map(permanent -> permanent.isControlledBy(controllerId)).mapToInt(x -> x != false ? 1 : 0).sum();
    }

    public String toString() {
        return "Permanents: " + this.field.size();
    }
}

