/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent;

import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.keyword.ChangelingAbility;
import mage.abilities.keyword.TransformAbility;
import mage.cards.Card;
import mage.constants.EmptyNames;
import mage.game.Game;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentImpl;
import mage.game.permanent.token.Token;
import mage.util.CardUtil;

public class PermanentToken
extends PermanentImpl {
    protected Token token;

    public PermanentToken(Token token, UUID controllerId, Game game) {
        super(controllerId, controllerId, token.getName());
        this.token = token.copy();
        this.token.getAbilities().newOriginalId();
        this.token.getAbilities().setSourceId(this.objectId);
        this.power = new MageInt(token.getPower().getModifiedBaseValue());
        this.toughness = new MageInt(token.getToughness().getModifiedBaseValue());
        this.copyFromToken(this.token, game, false);
        if (this.token.isEntersTransformed()) {
            TransformAbility.transformPermanent(this, game, null);
        }
        if (game != null) {
            this.setZoneChangeCounter(this.token.getZoneChangeCounter(game), game);
        }
    }

    protected PermanentToken(PermanentToken permanent) {
        super(permanent);
        this.token = permanent.token.copy();
    }

    @Override
    public void reset(Game game) {
        this.copyFromToken(this.token, game, true);
        super.reset(game);
        this.power.resetToBaseValue();
        this.toughness.resetToBaseValue();
    }

    @Override
    public int getManaValue() {
        if (this.isTransformed()) {
            return this.token.getManaValue();
        }
        return super.getManaValue();
    }

    @Override
    public String getName() {
        if (this.name.isEmpty()) {
            return EmptyNames.FACE_DOWN_TOKEN.getObjectName();
        }
        return this.name;
    }

    private void copyFromToken(Token token, Game game, boolean reset) {
        this.name = token.getName();
        this.abilities.clear();
        if (reset) {
            this.abilities.addAll(token.getAbilities());
        } else {
            for (Ability ability : token.getAbilities()) {
                this.addAbility(ability, null, game, true);
            }
        }
        this.abilities.setControllerId(this.controllerId);
        this.manaCost.clear();
        for (ManaCost cost : token.getManaCost()) {
            this.getManaCost().add(cost.copy());
        }
        this.cardType.clear();
        this.cardType.addAll(token.getCardType(game));
        this.color = token.getColor(game).copy();
        this.frameColor = token.getFrameColor(game);
        this.frameStyle = token.getFrameStyle();
        this.supertype.clear();
        this.supertype.addAll(token.getSuperType(game));
        this.subtype.copyFrom(token.getSubtype(game));
        this.startingLoyalty = token.getStartingLoyalty();
        this.startingDefense = token.getStartingDefense();
        if (this.abilities.containsClass(ChangelingAbility.class)) {
            this.subtype.setIsAllCreatureTypes(true);
        }
        CardUtil.copySetAndCardNumber(this, token);
    }

    @Override
    public MageObject getBasicMageObject() {
        return this.token;
    }

    public Token getToken() {
        return this.token;
    }

    @Override
    public PermanentToken copy() {
        return new PermanentToken(this);
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        super.updateZoneChangeCounter(game, event);
    }

    @Override
    public Card getMainCard() {
        return this;
    }

    @Override
    public boolean isTransformable() {
        return this.token.getBackFace() != null;
    }

    @Override
    public MageObject getOtherFace() {
        return this.transformed ? this.token : this.token.getBackFace();
    }
}

