/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DaxosSpiritSetPTEffect
extends ContinuousEffectImpl {
    public DaxosSpiritSetPTEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.SetPT_7b, Outcome.BoostCreature);
        this.staticText = "This creature's power and toughness are each equal to the number of experience counters you have";
    }

    protected DaxosSpiritSetPTEffect(DaxosSpiritSetPTEffect effect) {
        super(effect);
    }

    @Override
    public DaxosSpiritSetPTEffect copy() {
        return new DaxosSpiritSetPTEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || !new MageObjectReference(source.getSourceObject(game), game).refersTo(permanent, game)) {
            this.discard();
            return false;
        }
        int amount = controller.getCountersCount(CounterType.EXPERIENCE);
        permanent.getPower().setModifiedBaseValue(amount);
        permanent.getToughness().setModifiedBaseValue(amount);
        return true;
    }
}

