/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.StaticFilters;
import mage.game.permanent.token.TokenImpl;
import mage.target.common.TargetCardInLibrary;

public final class LanderToken
extends TokenImpl {
    public static String getReminderText() {
        return "<i>(It's an artifact with \"{2}, {T}, Sacrifice this token: Search your library for a basic land card, put it onto the battlefield tapped, then shuffle.\")</i>";
    }

    public LanderToken() {
        super("Lander Token", "Lander token");
        this.cardType.add(CardType.ARTIFACT);
        this.subtype.add(SubType.LANDER);
        SimpleActivatedAbility ability = new SimpleActivatedAbility(new SearchLibraryPutInPlayEffect(new TargetCardInLibrary(StaticFilters.FILTER_CARD_BASIC_LAND_A), true), new GenericManaCost(2));
        ability.addCost(new TapSourceCost());
        ability.addCost(new SacrificeSourceCost());
        this.addAbility(ability);
    }

    private LanderToken(LanderToken token) {
        super(token);
    }

    @Override
    public LanderToken copy() {
        return new LanderToken(this);
    }
}

