/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.MageObjectImpl;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.keyword.BestowAbility;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.Card;
import mage.cards.repository.TokenInfo;
import mage.cards.repository.TokenRepository;
import mage.cards.repository.TokenType;
import mage.constants.Outcome;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.CreatedTokenEvent;
import mage.game.events.CreatedTokensEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.EmptyToken;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;
import mage.target.Target;
import org.apache.log4j.Logger;

public abstract class TokenImpl
extends MageObjectImpl
implements Token {
    private static final Logger logger = Logger.getLogger(MageObjectImpl.class);
    protected String description;
    private final ArrayList<UUID> lastAddedTokenIds = new ArrayList();
    private Card copySourceCard;
    private static final int MAX_TOKENS_PER_GAME = 500;
    protected Token backFace = null;
    private boolean entersTransformed = false;

    public TokenImpl() {
    }

    public TokenImpl(String name, String description) {
        this.name = name;
        this.description = description;
        if (description.startsWith("a ") || description.startsWith("an ")) {
            throw new IllegalArgumentException("Wrong code usage: don't use indefinite article here - " + description);
        }
    }

    protected TokenImpl(TokenImpl token) {
        super(token);
        this.description = token.description;
        this.lastAddedTokenIds.addAll(token.lastAddedTokenIds);
        this.copySourceCard = token.copySourceCard;
        this.backFace = token.backFace != null ? token.backFace.copy() : null;
        this.entersTransformed = token.entersTransformed;
    }

    @Override
    public abstract Token copy();

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<UUID> getLastAddedTokenIds() {
        return new ArrayList<UUID>(this.lastAddedTokenIds);
    }

    @Override
    public void addAbility(Ability ability) {
        this.addAbility(ability, false);
    }

    @Override
    public void addAbility(Ability ability, boolean fromExistingObject) {
        ability.setSourceId(this.getId());
        this.abilities.add(ability);
        if (!fromExistingObject) {
            this.abilities.addAll(ability.getSubAbilities());
        }
    }

    @Override
    public void removeAbility(Ability abilityToRemove) {
        if (abilityToRemove == null) {
            return;
        }
        ArrayList toRemove = new ArrayList();
        this.abilities.forEach(a -> {
            if (a.isSameInstance(abilityToRemove)) {
                toRemove.add(a);
            }
        });
        toRemove.forEach(r -> this.abilities.remove(r));
    }

    @Override
    public void removeAbilities(List<Ability> abilitiesToRemove) {
        if (abilitiesToRemove == null) {
            return;
        }
        abilitiesToRemove.forEach(a -> this.removeAbility((Ability)a));
    }

    @Override
    public boolean putOntoBattlefield(int amount, Game game, Ability source) {
        return this.putOntoBattlefield(amount, game, source, source.getControllerId());
    }

    @Override
    public boolean putOntoBattlefield(int amount, Game game, Ability source, UUID controllerId) {
        return this.putOntoBattlefield(amount, game, source, controllerId, false, false);
    }

    @Override
    public boolean putOntoBattlefield(int amount, Game game, Ability source, UUID controllerId, boolean tapped, boolean attacking) {
        return this.putOntoBattlefield(amount, game, source, controllerId, tapped, attacking, null);
    }

    public static TokenInfo generateTokenInfo(TokenImpl token, Game game, UUID sourceId) {
        MageObject sourceObject;
        if (!token.getCardNumber().isEmpty()) {
            return new TokenInfo(TokenType.TOKEN, token.getName(), token.getExpansionSetCode(), 0);
        }
        if (token instanceof EmptyToken) {
            if (token.getExpansionSetCode() == null) {
                throw new IllegalArgumentException("Wrong code usage: can't copy token without set code");
            }
            return new TokenInfo(TokenType.TOKEN, token.getName(), token.getExpansionSetCode(), token.getImageNumber());
        }
        Card sourceCard = game.getCard(sourceId);
        String setCode = sourceCard != null ? sourceCard.getExpansionSetCode() : ((sourceObject = game.getObject(sourceId)) != null ? sourceObject.getExpansionSetCode() : null);
        TokenInfo foundInfo = TokenRepository.instance.findPreferredTokenInfoForClass(token.getClass().getName(), setCode);
        if (foundInfo != null) {
            return foundInfo;
        }
        if (token instanceof CreatureToken) {
            // empty if block
        }
        return new TokenInfo(TokenType.TOKEN, "Unknown", "XMAGE", 0);
    }

    @Override
    public boolean putOntoBattlefield(int amount, Game game, Ability source, UUID controllerId, boolean tapped, boolean attacking, UUID attackedPlayer) {
        return this.putOntoBattlefield(amount, game, source, controllerId, tapped, attacking, attackedPlayer, null);
    }

    @Override
    public boolean putOntoBattlefield(int amount, Game game, Ability source, UUID controllerId, boolean tapped, boolean attacking, UUID attackedPlayer, UUID attachedTo) {
        return this.putOntoBattlefield(amount, game, source, controllerId, tapped, attacking, attackedPlayer, attachedTo, true);
    }

    @Override
    public boolean putOntoBattlefield(int amount, Game game, Ability source, UUID controllerId, boolean tapped, boolean attacking, UUID attackedPlayer, UUID attachedTo, boolean created) {
        return this.putOntoBattlefield(amount, game, source, controllerId, tapped, attacking, attackedPlayer, attachedTo, created, Collections.singletonList(this));
    }

    @Override
    public boolean putOntoBattlefield(int amount, Game game, Ability source, UUID controllerId, boolean tapped, boolean attacking, UUID attackedPlayer, UUID attachedTo, boolean created, List<Token> tokens) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        if (amount == 0) {
            return false;
        }
        this.lastAddedTokenIds.clear();
        if (tokens == null || tokens.get(0) != this) {
            throw new IllegalArgumentException("Wrong code usage. token.putOntoBattlefield parameter tokens must be initialized to a list of all tokens to be made, with the first element being the token you are calling putOntoBattlefield() on.");
        }
        CreateTokenEvent event = new CreateTokenEvent(source, controllerId, amount, tokens);
        if (!created || !game.replaceEvent(event)) {
            int currentTokens = game.getBattlefield().countTokens(event.getPlayerId());
            int tokenSlots = Math.max(500 - currentTokens, 0);
            int amountToRemove = event.getAmount() - tokenSlots;
            if (amountToRemove > 0) {
                game.informPlayers("The token limit per player is 500, " + controller.getName() + " will only create " + tokenSlots + " tokens.");
                Iterator<Map.Entry<Token, Integer>> it = event.getTokens().entrySet().iterator();
                while (it.hasNext() && amountToRemove > 0) {
                    Map.Entry<Token, Integer> entry = it.next();
                    int newValue = entry.getValue() - amountToRemove;
                    if (newValue > 0) {
                        entry.setValue(newValue);
                        break;
                    }
                    amountToRemove -= entry.getValue().intValue();
                    it.remove();
                }
            }
            TokenImpl.putOntoBattlefieldHelper(event, game, source, tapped, attacking, attackedPlayer, attachedTo, created);
            event.getTokens().keySet().stream().map(Token::getLastAddedTokenIds).flatMap(Collection::stream).distinct().filter(uuid -> !this.lastAddedTokenIds.contains(uuid)).forEach(this.lastAddedTokenIds::add);
            return true;
        }
        return false;
    }

    private static void putOntoBattlefieldHelper(CreateTokenEvent event, Game game, Ability source, boolean tapped, boolean attacking, UUID attackedPlayer, UUID attachedTo, boolean created) {
        Player controller = game.getPlayer(event.getPlayerId());
        if (controller == null) {
            return;
        }
        HashSet<PermanentToken> allAddedTokens = new HashSet<PermanentToken>();
        block0: for (Map.Entry<Token, Integer> entry : event.getTokens().entrySet()) {
            Permanent permanentAttachedTo;
            Token token = entry.getKey();
            int amount = entry.getValue();
            if (attachedTo != null) {
                permanentAttachedTo = game.getPermanent(attachedTo);
                if (permanentAttachedTo == null || permanentAttachedTo.cantBeAttachedBy(token, source, game, true)) {
                    game.informPlayers(token.getName() + " will not be created as it cannot be attached to the chosen permanent");
                    continue;
                }
            } else {
                permanentAttachedTo = null;
            }
            TokenInfo tokenInfo = TokenImpl.generateTokenInfo((TokenImpl)token, game, source == null ? null : source.getSourceId());
            token.setExpansionSetCode(tokenInfo.getSetCode());
            token.setImageNumber(tokenInfo.getImageNumber());
            if (token.getBackFace() != null) {
                tokenInfo = TokenImpl.generateTokenInfo((TokenImpl)token.getBackFace(), game, source == null ? null : source.getSourceId());
                token.getBackFace().setExpansionSetCode(tokenInfo.getSetCode());
                token.getBackFace().setImageNumber(tokenInfo.getImageNumber());
            }
            ArrayList<PermanentToken> needTokens = new ArrayList<PermanentToken>();
            ArrayList<Permanent> allowedTokens = new ArrayList<Permanent>();
            for (int i = 0; i < amount; ++i) {
                PermanentToken permanentToken = new PermanentToken(token, event.getPlayerId(), game);
                game.getState().addCard(permanentToken);
                needTokens.add(permanentToken);
                game.getPermanentsEntering().put(permanentToken.getId(), permanentToken);
                permanentToken.setTapped(tapped);
                ZoneChangeEvent emptyEvent = new ZoneChangeEvent(permanentToken, permanentToken.getControllerId(), Zone.OUTSIDE, Zone.BATTLEFIELD);
                permanentToken.updateZoneChangeCounter(game, emptyEvent);
                if (source == null) continue;
                MageObjectReference mor = new MageObjectReference(permanentToken.getId(), permanentToken.getZoneChangeCounter(game) - 1, game);
                game.storePermanentCostsTags(mor, source);
            }
            game.setScopeRelevant(true);
            for (Permanent permanent : needTokens) {
                if (permanent.entersBattlefield(source, game, Zone.OUTSIDE, true)) {
                    allowedTokens.add(permanent);
                    continue;
                }
                game.getPermanentsEntering().remove(permanent.getId());
            }
            game.setScopeRelevant(false);
            int createOrder = game.getState().getNextPermanentOrderNumber();
            for (Permanent permanent : allowedTokens) {
                game.addPermanent(permanent, createOrder);
                permanent.setZone(Zone.BATTLEFIELD, game);
                game.getPermanentsEntering().remove(permanent.getId());
                if (token instanceof TokenImpl) {
                    ((TokenImpl)token).lastAddedTokenIds.add(permanent.getId());
                }
                ZoneChangeEvent zccEvent = new ZoneChangeEvent(permanent, permanent.getControllerId(), Zone.OUTSIDE, Zone.BATTLEFIELD);
                game.addSimultaneousEvent(zccEvent);
                if (permanent instanceof PermanentToken && created) {
                    game.addSimultaneousEvent(new CreatedTokenEvent(source, (PermanentToken)permanent));
                    allAddedTokens.add((PermanentToken)permanent);
                }
                if (source instanceof SpellAbility && ((SpellAbility)source).getSpellAbilityCastMode() == SpellAbilityCastMode.PROTOTYPE) {
                    permanent.setPrototyped(true);
                }
                if (created && permanent.getSubtype().contains((Object)SubType.AURA) && attachedTo == null) {
                    Outcome auraOutcome = Outcome.BoostCreature;
                    Target auraTarget = null;
                    for (Ability ability2 : permanent.getAbilities()) {
                        if (!(ability2 instanceof SpellAbility)) continue;
                        auraOutcome = ability2.getEffects().getOutcome(ability2);
                        for (Effect effect : ability2.getEffects()) {
                            if (!(effect instanceof AttachEffect) || permanent.getSpellAbility().getTargets().size() <= 0) continue;
                            auraTarget = (Target)permanent.getSpellAbility().getTargets().get(0);
                        }
                    }
                    if (auraTarget == null) {
                        for (Ability ability2 : permanent.getAbilities()) {
                            if (!(ability2 instanceof EnchantAbility)) continue;
                            auraOutcome = ability2.getEffects().getOutcome(ability2);
                            if (ability2.getTargets().size() <= 0) continue;
                            auraTarget = (Target)ability2.getTargets().get(0);
                        }
                    }
                    if (auraTarget == null) continue block0;
                    if (auraTarget.getFirstTarget() != null) {
                        auraTarget.remove(auraTarget.getFirstTarget());
                    }
                    auraTarget.withNotTarget(true);
                    if (!controller.choose(auraOutcome, auraTarget, source, game)) continue block0;
                    UUID targetId = auraTarget.getFirstTarget();
                    Permanent targetPermanent = game.getPermanent(targetId);
                    Player targetPlayer = game.getPlayer(targetId);
                    if (targetPermanent != null) {
                        targetPermanent.addAttachment(permanent.getId(), source, game);
                    } else if (targetPlayer != null) {
                        targetPlayer.addAttachment(permanent.getId(), source, game);
                    }
                }
                boolean isBestow = permanent.getAbilities().stream().anyMatch(ability -> ability instanceof BestowAbility);
                if (permanentAttachedTo != null && !isBestow) {
                    if (permanent.hasSubtype(SubType.AURA, game)) {
                        ((Target)((Ability)permanent.getAbilities().get(0)).getTargets().get(0)).add(permanentAttachedTo.getId(), game);
                        ((Effect)((Ability)permanent.getAbilities().get(0)).getEffects().get(0)).apply(game, (Ability)permanent.getAbilities().get(0));
                    } else {
                        permanentAttachedTo.addAttachment(permanent.getId(), source, game);
                    }
                }
                if (attacking && game.getCombat() != null && game.getActivePlayerId().equals(permanent.getControllerId())) {
                    game.getCombat().addAttackingCreature(permanent.getId(), game, attackedPlayer);
                }
                if (created) {
                    game.informPlayers(controller.getLogName() + " creates a " + permanent.getLogName() + " token");
                    continue;
                }
                game.informPlayers(permanent.getLogName() + " enters the battlefield as a token under " + controller.getLogName() + "'s control'");
            }
        }
        CreatedTokensEvent.addEvents(allAddedTokens, source, game);
        game.applyEffects();
    }

    @Override
    public void setPower(int power) {
        this.power = new MageInt(power);
    }

    @Override
    public void setToughness(int toughness) {
        this.toughness = new MageInt(toughness);
    }

    @Override
    public Card getCopySourceCard() {
        return this.copySourceCard;
    }

    @Override
    public void setCopySourceCard(Card copySourceCard) {
        if (copySourceCard != null) {
            this.copySourceCard = copySourceCard.copy();
        }
    }

    @Override
    public Token getBackFace() {
        return this.backFace;
    }

    @Override
    public void setEntersTransformed(boolean entersTransformed) {
        this.entersTransformed = entersTransformed;
    }

    @Override
    public void setColor(ObjectColor color) {
        this.getColor().setColor(color);
    }

    @Override
    public void clearManaCost() {
        this.getManaCost().clear();
    }

    @Override
    public boolean isEntersTransformed() {
        return this.entersTransformed && this.backFace != null;
    }

    @Override
    public void setExpansionSetCode(String expansionSetCode) {
        super.setExpansionSetCode(expansionSetCode);
    }

    @Override
    public void setImageNumber(Integer imageNumber) {
        super.setImageNumber(imageNumber);
    }

    public static TokenImpl createTokenByClassName(String fullClassName) {
        try {
            Class<?> c = Class.forName(fullClassName);
            Constructor<?> cons = c.getConstructor(new Class[0]);
            Object newToken = cons.newInstance(new Object[0]);
            if (newToken instanceof Token) {
                return (TokenImpl)newToken;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

