/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.PermanentToken;

class ValorsReachTagTeamTokenTriggeredAbility
extends TriggeredAbilityImpl {
    ValorsReachTagTeamTokenTriggeredAbility() {
        super(Zone.BATTLEFIELD, new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
    }

    private ValorsReachTagTeamTokenTriggeredAbility(ValorsReachTagTeamTokenTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public ValorsReachTagTeamTokenTriggeredAbility copy() {
        return new ValorsReachTagTeamTokenTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackers().contains(this.getSourceId())) return false;
        if (!game.getCombat().getAttackers().stream().filter(uuid -> !this.getSourceId().equals(uuid)).map(game::getPermanent).anyMatch(PermanentToken.class::isInstance)) return false;
        return true;
    }

    @Override
    public String getRule() {
        return "Whenever this creature and at least one other creature token attack, put a +1/+1 counter on this creature.";
    }
}

