/*
 * Decompiled with CFR 0.152.
 */
package mage.game.stack;

import java.util.ArrayDeque;
import java.util.Date;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.collectors.DataCollectorServices;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.util.CardUtil;
import org.apache.log4j.Logger;

public class SpellStack
extends ArrayDeque<StackObject> {
    private static final Logger logger = Logger.getLogger(SpellStack.class);
    protected Date dateLastAdded;

    public SpellStack() {
    }

    protected SpellStack(SpellStack stack) {
        for (StackObject spell : stack) {
            this.addLast(spell.copy());
        }
    }

    public void resolve(Game game) {
        StackObject top = null;
        try {
            top = (StackObject)this.peek();
            top.resolve(game);
            game.resetControlAfterSpellResolve(top.getId());
        }
        finally {
            if (top != null && this.contains(top)) {
                logger.warn((Object)("StackObject was still on the stack after resolving" + top.getName()));
                this.remove(top, game);
            }
        }
    }

    @Override
    @Deprecated
    public StackObject getFirst() {
        return (StackObject)super.getFirst();
    }

    public StackObject getFirstOrNull() {
        return this.isEmpty() ? null : this.getFirst();
    }

    public boolean remove(StackObject object, Game game) {
        for (StackObject spell : this) {
            if (!spell.getId().equals(object.getId())) continue;
            game.getState().setZone(spell.getId(), null);
            return super.remove(spell);
        }
        return false;
    }

    public boolean counter(UUID objectId, Ability source, Game game) {
        return this.counter(objectId, source, game, PutCards.GRAVEYARD);
    }

    public boolean counter(UUID objectId, Ability source, Game game, PutCards putCard) {
        StackObject stackObject = this.getStackObject(objectId);
        MageObject sourceObject = game.getObject(source);
        if (stackObject != null && sourceObject != null) {
            MageObject targetSourceObject = game.getObject(stackObject.getSourceId());
            String targetSourceName = targetSourceObject == null ? "[Object not found]" : game.getObject(stackObject.getSourceId()).getLogName();
            String counteredObjectName = stackObject instanceof Spell ? targetSourceName : "Ability (" + stackObject.getStackAbility().getRule(targetSourceName) + ") of " + targetSourceName;
            if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.COUNTER, objectId, source, stackObject.getControllerId()))) {
                if (!(stackObject instanceof Spell) || stackObject.isCopy()) {
                    this.remove(stackObject, game);
                    game.rememberLKI(Zone.STACK, stackObject);
                }
                stackObject.counter(source, game, putCard);
                if (!game.isSimulation()) {
                    game.informPlayers(counteredObjectName + " is countered by " + sourceObject.getLogName());
                }
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.COUNTERED, objectId, source, stackObject.getControllerId()));
                return true;
            }
            if (!game.isSimulation()) {
                game.informPlayers(counteredObjectName + " could not be countered by " + sourceObject.getLogName());
            }
        }
        return false;
    }

    public StackObject getStackObject(UUID id) {
        for (StackObject stackObject : this) {
            UUID objectId = stackObject.getId();
            if (objectId.equals(id)) {
                return stackObject;
            }
            UUID sourceId = stackObject.getSourceId();
            if (!sourceId.equals(id)) continue;
            return stackObject;
        }
        return null;
    }

    public Spell getSpell(UUID id) {
        return this.getSpell(id, true);
    }

    public Spell getSpell(UUID id, boolean allowCopies) {
        for (StackObject stackObject : this) {
            if (!(stackObject instanceof Spell) || !stackObject.getId().equals(id) && !stackObject.getSourceId().equals(id) || !allowCopies && stackObject.isCopy()) continue;
            return (Spell)stackObject;
        }
        return null;
    }

    public SpellStack copy() {
        return new SpellStack(this);
    }

    @Override
    @Deprecated
    public void push(StackObject e) {
        super.push(e);
        this.dateLastAdded = new Date();
    }

    public void push(Game game, StackObject e) {
        super.push(e);
        this.dateLastAdded = new Date();
        DataCollectorServices.getInstance().onTestsStackPush(game);
    }

    public Date getDateLastAdded() {
        return this.dateLastAdded;
    }

    @Override
    public String toString() {
        return this.size() + (this.isEmpty() ? "" : " (top: " + CardUtil.substring(this.getFirst().toString(), 100, "...") + ")");
    }
}

