/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import mage.cards.ExpansionSet;
import mage.cards.decks.Deck;
import mage.game.draft.Draft;
import mage.game.events.Listener;
import mage.game.events.PlayerQueryEvent;
import mage.game.events.TableEvent;
import mage.game.result.ResultProtos;
import mage.game.tournament.Round;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPlayer;
import mage.game.tournament.TournamentType;
import mage.players.Player;
import mage.players.PlayerType;

public interface Tournament {
    public UUID getId();

    public void addPlayer(Player var1, PlayerType var2);

    public void removePlayer(UUID var1);

    public TournamentPlayer getPlayer(UUID var1);

    public Collection<TournamentPlayer> getPlayers();

    public Collection<Round> getRounds();

    public List<ExpansionSet> getSets();

    public void updateResults();

    public void setBoosterInfo(String var1);

    public String getBoosterInfo();

    public void submitDeck(UUID var1, Deck var2);

    public void updateDeck(UUID var1, Deck var2, boolean var3);

    public void autoSubmit(UUID var1, Deck var2);

    public boolean allJoined();

    public boolean isDoneConstructing();

    public void quit(UUID var1);

    public void leave(UUID var1);

    public void nextStep();

    public void addTableEventListener(Listener<TableEvent> var1);

    public void addPlayerQueryEventListener(Listener<PlayerQueryEvent> var1);

    public void fireConstructEvent(UUID var1);

    public TournamentOptions getOptions();

    public void setStartTime();

    public Date getStartTime();

    public Date getEndTime();

    public Date getStepStartTime();

    public void setStepStartTime(Date var1);

    public TournamentType getTournamentType();

    public void setTournamentType(TournamentType var1);

    public String getTournamentState();

    public void setTournamentState(String var1);

    public int getNumberRounds();

    public void cleanUpOnTournamentEnd();

    public boolean isAbort();

    public void setAbort(boolean var1);

    public void clearDraft();

    public Draft getDraft();

    public ResultProtos.TourneyProto toProto();
}

