/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament;

import java.util.List;
import java.util.Map;
import mage.constants.MultiplayerAttackOption;
import mage.constants.TournamentPlayerState;
import mage.game.events.TableEvent;
import mage.game.tournament.MultiplayerRound;
import mage.game.tournament.Round;
import mage.game.tournament.TournamentImpl;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPairing;
import mage.game.tournament.TournamentPlayer;
import mage.game.tournament.pairing.RoundPairings;
import mage.game.tournament.pairing.SwissPairingMinimalWeightMatching;
import mage.game.tournament.pairing.SwissPairingSimple;

public abstract class TournamentSwiss
extends TournamentImpl {
    public TournamentSwiss(TournamentOptions options) {
        super(options);
    }

    @Override
    protected void runTournament() {
        Object round;
        for (Map.Entry entry : this.players.entrySet()) {
            if (!((TournamentPlayer)entry.getValue()).getPlayer().autoLoseGame()) continue;
            ((TournamentPlayer)entry.getValue()).setEliminated();
            ((TournamentPlayer)entry.getValue()).setResults("Auto Eliminated");
        }
        if (this.options.matchOptions.isSingleGameTourney()) {
            this.options.matchOptions.setAttackOption(MultiplayerAttackOption.MULTIPLE);
            round = new MultiplayerRound(0, this);
            for (TournamentPlayer player : this.getActivePlayers()) {
                ((MultiplayerRound)round).addPlayer(player);
            }
            this.playMultiplayerRound((MultiplayerRound)round);
        } else {
            while (this.getActivePlayers().size() > 1 && this.getNumberRounds() > this.getRounds().size()) {
                this.tableEventSource.fireTableEvent(TableEvent.EventType.CHECK_STATE_PLAYERS);
                round = this.createRoundSwiss();
                this.playRound((Round)round);
            }
        }
        this.nextStep();
    }

    protected Round createRoundSwiss() {
        RoundPairings roundPairings;
        Object swissPairing;
        boolean isLastRound;
        List<TournamentPlayer> roundPlayers = this.getActivePlayers();
        boolean bl = isLastRound = this.rounds.size() + 1 == this.getNumberRounds();
        if (this.options.matchOptions.isSingleGameTourney()) {
            throw new IllegalStateException("Wrong code usage: multi rounds for non single game tourneys only (e.g. with two seats)");
        }
        Round round = null;
        if (roundPlayers.size() <= 16) {
            swissPairing = new SwissPairingMinimalWeightMatching(roundPlayers, this.rounds, isLastRound);
            roundPairings = ((SwissPairingMinimalWeightMatching)swissPairing).getRoundPairings();
        } else {
            swissPairing = new SwissPairingSimple(roundPlayers, this.rounds);
            roundPairings = ((SwissPairingSimple)swissPairing).getRoundPairings();
        }
        round = new Round(this.rounds.size() + 1, this);
        this.rounds.add(round);
        for (TournamentPairing pairing : roundPairings.getPairings()) {
            round.addPairing(pairing);
        }
        for (TournamentPlayer playerBye : roundPairings.getPlayerByes()) {
            round.getPlayerByes().add(playerBye);
            if (isLastRound) {
                playerBye.setState(TournamentPlayerState.FINISHED);
            } else {
                playerBye.setState(TournamentPlayerState.WAITING);
            }
            playerBye.setStateInfo("Round Bye");
            this.updateResults();
        }
        return round;
    }
}

