/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament.pairing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mage.game.tournament.Round;
import mage.game.tournament.TournamentPairing;
import mage.game.tournament.TournamentPlayer;
import mage.game.tournament.pairing.RoundPairings;

public class SwissPairingMinimalWeightMatching {
    private final int playersCount;
    private List<PlayerInfo> swissPlayers;
    private final int n;
    private final int[][] w;
    private boolean[] used;
    private int[] pairs;
    private int weight;
    private int[] result;
    private int minCost;

    public SwissPairingMinimalWeightMatching(List<TournamentPlayer> players, List<Round> rounds, boolean isLastRound) {
        int i;
        this.playersCount = players.size();
        this.swissPlayers = new ArrayList<PlayerInfo>();
        for (TournamentPlayer tournamentPlayer : players) {
            PlayerInfo swissPlayer = new PlayerInfo();
            swissPlayer.setTournamentPlayer(tournamentPlayer);
            swissPlayer.setPoints(tournamentPlayer.getPoints());
            this.swissPlayers.add(swissPlayer);
        }
        Collections.shuffle(this.swissPlayers);
        HashMap<TournamentPlayer, Integer> map = new HashMap<TournamentPlayer, Integer>();
        for (int i2 = 0; i2 < this.playersCount; ++i2) {
            this.swissPlayers.get(i2).setId(i2);
            map.put(this.swissPlayers.get(i2).getTournamentPlayer(), i2);
        }
        for (Round round : rounds) {
            for (TournamentPairing pairing : round.getPairs()) {
                Iterator<TournamentPlayer> player1 = pairing.getPlayer1();
                TournamentPlayer player2 = pairing.getPlayer2();
                Integer id1 = (Integer)map.get(player1);
                Integer id2 = (Integer)map.get(player2);
                if (id1 != null) {
                    this.swissPlayers.get(id1).setSosPoints(this.swissPlayers.get(id1).getSosPoints() + player2.getPoints());
                }
                if (id2 == null) continue;
                this.swissPlayers.get(id2).setSosPoints(this.swissPlayers.get(id2).getSosPoints() + ((TournamentPlayer)((Object)player1)).getPoints());
            }
        }
        this.swissPlayers.sort((p1, p2) -> {
            int result = p2.getPoints() - p1.getPoints();
            if (result != 0) {
                return result;
            }
            return p2.getSosPoints() - p1.getSosPoints();
        });
        map.clear();
        for (int i3 = 0; i3 < this.playersCount; ++i3) {
            this.swissPlayers.get(i3).setId(i3);
            map.put(this.swissPlayers.get(i3).getTournamentPlayer(), i3);
        }
        int[][] duels = new int[this.playersCount][this.playersCount];
        int[] byes = new int[this.playersCount];
        for (Round round : rounds) {
            for (TournamentPairing pairing : round.getPairs()) {
                TournamentPlayer player1 = pairing.getPlayer1();
                TournamentPlayer player2 = pairing.getPlayer2();
                Integer id1 = (Integer)map.get(player1);
                Integer id2 = (Integer)map.get(player2);
                if (id1 == null || id2 == null) continue;
                int[] nArray = duels[id1];
                int n = id2;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = duels[id2];
                int n2 = id1;
                nArray2[n2] = nArray2[n2] + 1;
            }
            for (TournamentPlayer playerBye : round.getPlayerByes()) {
                Integer id = (Integer)map.get(playerBye);
                if (id == null) continue;
                int n = id;
                byes[n] = byes[n] + 1;
            }
        }
        this.n = this.playersCount % 2 == 1 ? this.playersCount + 1 : this.playersCount;
        this.w = new int[this.n][this.n];
        int pointsDiffMultiplier = 10;
        if (isLastRound) {
            for (i = 0; i < this.playersCount; ++i) {
                for (int j = 0; j < i; ++j) {
                    this.w[i][j] = Math.abs(i - j) + pointsDiffMultiplier * Math.abs(this.swissPlayers.get(i).getPoints() - this.swissPlayers.get(j).getPoints());
                    this.w[j][i] = this.w[i][j];
                }
            }
        } else {
            for (i = 0; i < this.playersCount; ++i) {
                PlayerInfo player = this.swissPlayers.get(i);
                for (int p = player.getPoints(); p >= 0; --p) {
                    int first = -1;
                    int last = -1;
                    for (int j = 0; j < this.playersCount; ++j) {
                        if (this.swissPlayers.get(j).getPoints() != p) continue;
                        if (first < 0) {
                            first = j;
                        }
                        last = j;
                    }
                    if (first < 0) continue;
                    int self = p == player.getPoints() ? i : first - 1;
                    int diff = pointsDiffMultiplier * (player.getPoints() - p);
                    for (int j = Math.max(first, i); j <= last; ++j) {
                        this.w[i][j] = Math.abs(j - (last + first - self)) + diff;
                        this.w[j][i] = this.w[i][j];
                    }
                }
            }
        }
        for (i = 0; i < this.playersCount; ++i) {
            for (int j = 0; j < i; ++j) {
                int[] nArray = this.w[i];
                int n = j;
                nArray[n] = nArray[n] + duels[i][j] * 500;
                this.w[j][i] = this.w[i][j];
            }
        }
        if (this.n > this.playersCount) {
            for (i = 0; i < this.playersCount; ++i) {
                this.w[i][this.n - 1] = 10 * (this.swissPlayers.get(i).getPoints() - this.swissPlayers.get(this.playersCount - 1).getPoints()) + (this.playersCount - i - 1);
                int[] nArray = this.w[i];
                int n = this.n - 1;
                nArray[n] = nArray[n] + byes[i] * 2000;
                this.w[this.n - 1][i] = this.w[i][this.n - 1];
            }
        }
        for (i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                int[] nArray = this.w[i];
                int n = j;
                nArray[n] = nArray[n] * this.w[i][j];
            }
        }
        this.used = new boolean[this.n];
        this.pairs = new int[this.n];
        Arrays.fill(this.pairs, -1);
        this.result = new int[this.n];
        this.weight = 0;
        this.minCost = -1;
        this.makePairings(0);
    }

    public RoundPairings getRoundPairings() {
        ArrayList<TournamentPairing> pairings = new ArrayList<TournamentPairing>();
        ArrayList<TournamentPlayer> playerByes = new ArrayList<TournamentPlayer>();
        HashMap<Integer, TournamentPlayer> map = new HashMap<Integer, TournamentPlayer>();
        for (PlayerInfo player : this.swissPlayers) {
            map.put(player.getId(), player.getTournamentPlayer());
        }
        if (this.n > this.playersCount) {
            playerByes.add((TournamentPlayer)map.get(this.result[this.n - 1]));
            this.result[this.result[this.n - 1]] = -1;
            this.result[this.n - 1] = -1;
        }
        for (int i = 0; i < this.playersCount; ++i) {
            if (this.result[i] < 0) continue;
            pairings.add(new TournamentPairing((TournamentPlayer)map.get(i), (TournamentPlayer)map.get(this.result[i])));
            this.result[this.result[i]] = -1;
            this.result[i] = -1;
        }
        return new RoundPairings(pairings, playerByes);
    }

    private void makePairings(int t) {
        if (t >= this.n) {
            if (this.minCost < 0 || this.minCost > this.weight) {
                this.minCost = this.weight;
                System.arraycopy(this.pairs, 0, this.result, 0, this.n);
            }
            return;
        }
        if (!this.used[t]) {
            for (int i = t + 1; i < this.n; ++i) {
                if (this.used[i]) continue;
                this.pairs[t] = i;
                this.pairs[i] = t;
                this.used[t] = true;
                this.used[i] = true;
                this.weight += this.w[t][i];
                this.makePairings(t + 1);
                this.pairs[t] = -1;
                this.pairs[i] = -1;
                this.used[t] = false;
                this.used[i] = false;
                this.weight -= this.w[t][i];
            }
        } else {
            this.makePairings(t + 1);
        }
    }

    static class PlayerInfo {
        private int id;
        private TournamentPlayer tournamentPlayer;
        private int points;
        private int sosPoints;

        PlayerInfo() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public TournamentPlayer getTournamentPlayer() {
            return this.tournamentPlayer;
        }

        public void setTournamentPlayer(TournamentPlayer tournamentPlayer) {
            this.tournamentPlayer = tournamentPlayer;
        }

        public int getPoints() {
            return this.points;
        }

        public void setPoints(int points) {
            this.points = points;
        }

        public int getSosPoints() {
            return this.sosPoints;
        }

        public void setSosPoints(int sosPoints) {
            this.sosPoints = sosPoints;
        }
    }
}

