/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament.pairing;

import java.util.ArrayList;
import java.util.List;
import mage.game.tournament.Round;
import mage.game.tournament.TournamentPairing;
import mage.game.tournament.TournamentPlayer;
import mage.game.tournament.pairing.RoundPairings;

public class SwissPairingSimple {
    private final RoundPairings roundPairings;

    public SwissPairingSimple(List<TournamentPlayer> players, List<Round> rounds) {
        this.roundPairings = this.getPairingsSimple(players, rounds);
    }

    public RoundPairings getRoundPairings() {
        return this.roundPairings;
    }

    private RoundPairings getPairingsSimple(List<TournamentPlayer> players, List<Round> rounds) {
        ArrayList<TournamentPairing> pairings = new ArrayList<TournamentPairing>();
        ArrayList<TournamentPlayer> playerByes = new ArrayList<TournamentPlayer>();
        players.sort((p1, p2) -> p2.getPoints() - p1.getPoints());
        while (!players.isEmpty()) {
            TournamentPlayer player1 = players.get(0);
            players.remove(0);
            TournamentPlayer playerForPossibleSecondPairing = null;
            for (TournamentPlayer player2 : players) {
                if (this.alreadyPaired(rounds, player1, player2)) {
                    if (playerForPossibleSecondPairing != null) continue;
                    playerForPossibleSecondPairing = player2;
                    continue;
                }
                if (player2.getPoints() < player1.getPoints() && playerForPossibleSecondPairing != null) {
                    pairings.add(new TournamentPairing(player1, playerForPossibleSecondPairing));
                    players.remove(playerForPossibleSecondPairing);
                    player1 = null;
                    break;
                }
                pairings.add(new TournamentPairing(player1, player2));
                players.remove(player2);
                player1 = null;
                break;
            }
            if (player1 == null) continue;
            if (playerForPossibleSecondPairing != null) {
                pairings.add(new TournamentPairing(player1, playerForPossibleSecondPairing));
                players.remove(playerForPossibleSecondPairing);
                continue;
            }
            playerByes.add(player1);
        }
        return new RoundPairings(pairings, playerByes);
    }

    private boolean alreadyPaired(List<Round> rounds, TournamentPlayer player1, TournamentPlayer player2) {
        for (Round round : rounds) {
            for (TournamentPairing pairing : round.getPairs()) {
                if (!pairing.getPlayer1().equals(player1) && !pairing.getPlayer2().equals(player1) || !pairing.getPlayer1().equals(player2) && !pairing.getPlayer2().equals(player2)) continue;
                return true;
            }
        }
        return false;
    }
}

