/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.util.UUID;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.Step;
import mage.players.Player;

public class CleanupStep
extends Step {
    public CleanupStep() {
        super(PhaseStep.CLEANUP, true);
        this.stepEvent = GameEvent.EventType.CLEANUP_STEP;
        this.preStepEvent = GameEvent.EventType.CLEANUP_STEP_PRE;
        this.postStepEvent = GameEvent.EventType.CLEANUP_STEP_POST;
    }

    protected CleanupStep(CleanupStep step) {
        super(step);
    }

    @Override
    public void beginStep(Game game, UUID activePlayerId) {
        super.beginStep(game, activePlayerId);
        Player activePlayer = game.getPlayer(activePlayerId);
        game.getState().setPriorityPlayerId(activePlayer.getId());
        if (activePlayer.isInGame()) {
            activePlayer.discardToMax(game);
        }
        game.getBattlefield().endOfTurn(game);
        game.getState().removeEotEffects(game);
    }

    @Override
    public void endStep(Game game, UUID activePlayerId) {
        super.endStep(game, activePlayerId);
    }

    @Override
    public CleanupStep copy() {
        return new CleanupStep(this);
    }
}

