/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.util.UUID;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.Step;
import mage.players.Player;

public class DrawStep
extends Step {
    public DrawStep() {
        super(PhaseStep.DRAW, true);
        this.stepEvent = GameEvent.EventType.DRAW_STEP;
        this.preStepEvent = GameEvent.EventType.DRAW_STEP_PRE;
        this.postStepEvent = GameEvent.EventType.DRAW_STEP_POST;
    }

    protected DrawStep(DrawStep step) {
        super(step);
    }

    @Override
    public void beginStep(Game game, UUID activePlayerId) {
        Player activePlayer = game.getPlayer(activePlayerId);
        activePlayer.drawCards(1, null, game);
        game.applyEffects();
        for (UUID playerId : game.getState().getPlayersInRange(activePlayerId, game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.isDrawsOnOpponentsTurn() || !player.hasOpponent(activePlayerId, game)) continue;
            player.drawCards(1, null, game);
        }
        super.beginStep(game, activePlayerId);
    }

    @Override
    public DrawStep copy() {
        return new DrawStep(this);
    }
}

