/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.util.UUID;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.Step;
import mage.players.Player;
import mage.watchers.common.CastSpellLastTurnWatcher;

public class UntapStep
extends Step {
    public UntapStep() {
        super(PhaseStep.UNTAP, false);
        this.stepEvent = GameEvent.EventType.UNTAP_STEP;
        this.preStepEvent = GameEvent.EventType.UNTAP_STEP_PRE;
        this.postStepEvent = GameEvent.EventType.UNTAP_STEP_POST;
    }

    protected UntapStep(UntapStep step) {
        super(step);
    }

    @Override
    public void beginStep(Game game, UUID activePlayerId) {
        super.beginStep(game, activePlayerId);
        this.handleDayNight(game);
        Player activePlayer = game.getPlayer(activePlayerId);
        activePlayer.phasing(game);
        activePlayer.untap(game);
        game.applyEffects();
    }

    @Override
    public UntapStep copy() {
        return new UntapStep(this);
    }

    private void handleDayNight(Game game) {
        if (!game.hasDayNight() || game.getTurnNum() <= 1) {
            return;
        }
        int previousSpells = game.getState().getWatcher(CastSpellLastTurnWatcher.class).getActivePlayerPrevTurnCount();
        if (game.checkDayNight(true) && previousSpells == 0) {
            game.setDaytime(false);
        } else if (game.checkDayNight(false) && previousSpells >= 2) {
            game.setDaytime(true);
        }
    }
}

