/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

import java.util.UUID;
import mage.game.Game;
import mage.players.Player;
import mage.util.CircularList;

public class PlayerList
extends CircularList<UUID> {
    public PlayerList() {
    }

    protected PlayerList(PlayerList list) {
        super(list);
    }

    public Player getCurrent(Game game) {
        return game.getPlayer((UUID)this.get());
    }

    public Player getNextInRange(Player basePlayer, Game game) {
        UUID nextPlayerId;
        UUID currentPlayerBefore = (UUID)this.get();
        UUID uUID = nextPlayerId = game.isTurnOrderReversed() ? (UUID)super.getPrevious() : (UUID)super.getNext();
        do {
            if (!basePlayer.hasPlayerInRange(nextPlayerId)) continue;
            return game.getPlayer(nextPlayerId);
        } while (!(nextPlayerId = game.isTurnOrderReversed() ? (UUID)super.getPrevious() : (UUID)super.getNext()).equals(currentPlayerBefore));
        return null;
    }

    public Player getNext(Game game, boolean checkNextTurnReached) {
        Player player;
        UUID start = (UUID)this.get();
        if (start == null) {
            return null;
        }
        while (!(player = this.getAffectedNext(game)).isInGame()) {
            if (checkNextTurnReached && !player.hasReachedNextTurnAfterLeaving()) {
                player.setReachedNextTurnAfterLeaving(true);
            }
            if (!player.getId().equals(start)) continue;
            return null;
        }
        return player;
    }

    public Player getPrevious(Game game) {
        Player player;
        UUID start = (UUID)this.get();
        if (start == null) {
            return null;
        }
        while (!(player = this.getAffectedPrevious(game)).isInGame()) {
            if (!player.getId().equals(start)) continue;
            return null;
        }
        return player;
    }

    private Player getAffectedNext(Game game) {
        return game.isTurnOrderReversed() ? game.getPlayer((UUID)super.getPrevious()) : game.getPlayer((UUID)super.getNext());
    }

    private Player getAffectedPrevious(Game game) {
        return game.isTurnOrderReversed() ? game.getPlayer((UUID)super.getNext()) : game.getPlayer((UUID)super.getPrevious());
    }

    public PlayerList copy() {
        return new PlayerList(this);
    }
}

